### Name: ProbBin.FCS
### Title: ProbBin.FCS R-object: Probability binning of 2 samples
### Aliases: ProbBin.FCS
### Keywords: univar classes

### ** Examples


if (require(rfcdmin)){

data.there<-is.element(c("st.1829", "unst.1829", "st.DRT", "unst.DRT"),objects())
if ( ( sum(data.there) != length(data.there) )){
## obtaining the FCS objects from VRC data
data(VRCmin)
}
## This only serves as an example.
## Gating/subsetting should precede this analysis
IFN.gamma.1<-unst.1829@data[1:2000,4]
IFN.gamma.2<-st.1829@data[1:2000,4]

#Probability binning using the control dataset to determine the breaks
PB1<-ProbBin.FCS(IFN.gamma.1, IFN.gamma.2, 200,
varname=colnames(unst.1829@data)[4], PBspec="by.control",MY.DEBUG=FALSE)

## Probability Binning using the combined dataset (control & stimulated)
## to determing the breaks
PB2<-ProbBin.FCS(IFN.gamma.1, IFN.gamma.2, 200,
varname=colnames(unst.1829@data)[4], PBspec="combined",MY.DEBUG=FALSE)
}




