### Name: smoothByRegion
### Title: reb
### Aliases: smoothByRegion reb
### Keywords: manip

### ** Examples


# The mcr.eset is a two-color gene expression exprSet
# with cytogenetically complex (MCR) and normal 
# control (MNC) samples which are a pooled-cell line reference.

data("mcr.eset")
data(idiogramExample)

## Create a vector with the index of normal samples
norms <- grep("MNC",colnames(mcr.eset@exprs))

## Smooth the data using the default 'movbin' method,
## with the normal samples as reference

cset <- reb(mcr.eset@exprs,vai.chr,ref=norms,center=TRUE)

## Display the results with midiogram
midiogram(cset@exprs[,-norms],vai.chr,method="i",dlim=c(-5,5),col=.rwb)



