###################################################
### chunk number 1: foo
###################################################
options(keep.source = TRUE, width = 60)
foo <- packageDescription("rHVDM")


###################################################
### chunk number 2: loading
###################################################
library(rHVDM) ##the three other packages also get loaded


###################################################
### chunk number 3: loadingdata
###################################################
data(HVDMexample)


###################################################
### chunk number 4: quickanddirtymeaserrors
###################################################
anothereset<-assayDataElementReplace(fiveGyMAS5,'se.exprs',5 + exprs(fiveGyMAS5)*0.1)


###################################################
### chunk number 5: deletedirtyset
###################################################
rm(anothereset)


###################################################
### chunk number 6: trypdatacommand
###################################################
pData(fiveGyMAS5)


###################################################
### chunk number 7: HVDMcheckcommand
###################################################
HVDMcheck(fiveGyMAS5)


###################################################
### chunk number 8: createnewpdata
###################################################
norepl3<-pData(fiveGyMAS5)
norepl3<-norepl3[norepl3$replicate!=3,]


###################################################
### chunk number 9: checknewpdata
###################################################
HVDMcheck(fiveGyMAS5,pdata=norepl3)


###################################################
### chunk number 10: garbagecollection
###################################################
rm(norepl3)


###################################################
### chunk number 11: training
###################################################
tHVDMp53<-training(eset=fiveGyMAS5,genes=p53traingenes,
				degrate=0.8,actname="p53")


###################################################
### chunk number 12: trainigunanchored
###################################################
tHVDMp53na<-training(eset=fiveGyMAS5,genes=p53traingenes,actname="p53")


###################################################
### chunk number 13: trainingbadgene
###################################################
tHVDMp53b<-training(eset=fiveGyMAS5,genes=c(p53traingenes,"202688_at"),
				degrate=0.8,actname="p53")


###################################################
### chunk number 14: garbagecollectionagain
###################################################
rm(tHVDMp53na,tHVDMp53b)


###################################################
### chunk number 15: agoodgene
###################################################
gHVDMCD38<-fitgene(eset=fiveGyMAS5,gene="205692_s_at",tHVDM=tHVDMp53)


###################################################
### chunk number 16: thesamegene
###################################################
gHVDMCD38<-fitgene(eset=fiveGyMAS5,gene="205692_s_at",tHVDM=tHVDMp53,
				firstguess=gHVDMCD38)


###################################################
### chunk number 17: badgene
###################################################
gHVDMtnf10<-fitgene(eset=fiveGyMAS5,gene="202688_at",tHVDM=tHVDMp53)


###################################################
### chunk number 18: screenall
###################################################
sHVDMp53<-screening(eset=fiveGyMAS5,genes=genestoscreen[1:5],HVDM=tHVDMp53)


###################################################
### chunk number 19: targetlist
###################################################
p53targets<-sHVDMp53$results[sHVDMp53$results$class1,]


###################################################
### chunk number 20: newscreen
###################################################
sHVDMp53<-screening(HVDM=sHVDMp53,cl1modelscorehigh=80.0,
			cl1zscorelow=3.5)


###################################################
### chunk number 21: extractavalue
###################################################
tHVDMp53$dm$signal[paste("202284_s_at","5Gy","2",6,sep=".")]


###################################################
### chunk number 22: extractanactivitytimepoint
###################################################
tHVDMp53$par$parameters[paste("p53","5Gy","2",6,sep=".")]


###################################################
### chunk number 23: extractaparameter
###################################################
tHVDMp53$par$parameters[paste("203409_at","Dj",sep=".")]


###################################################
### chunk number 24: knownvalues
###################################################
tHVDMp53$distribute$known


###################################################
### chunk number 25: freeparams
###################################################
tHVDMp53$par$parameters[tHVDMp53$distribute$free]


###################################################
### chunk number 26: scoreobject
###################################################
tHVDMp53$scores$withintc[[1]]$score


###################################################
### chunk number 27: differentialoperator
###################################################
tHVDMp53$tc[[1]]$A


###################################################
### chunk number 28: confidenceintervalsfortraining
###################################################
vcov<-solve(tHVDMp53$results$hessian)
sdev<-1.96*diag(vcov)^0.5 #compute half confidence interval in 
			#transformed domain
work<-tHVDMp53 #create a copy of the example to work with
central<-.exportfree(work) #extract transformed, fitted values
nams<-names(central) #extract vector of labels
upperbounds<-
  (.importfree(HVDM=work,x=central[nams]+sdev[nams]))$par$parameters
  
  #.importfree() imports the transformed values for the upper bound
  #into the "work" object and performs the inverse transform (here, an 
  #exponential) upon import, a new HVDM object is returned by this 
  #command. The $par$parameters suffix extracts the parameter vector. 
  #Note that the upperbounds vector will contain all parameter values, 
  #ie not only those fitted in LM.
  
lowerbounds<-
  (.importfree(HVDM=work,x=central[nams]-sdev[nams]))$par$parameters
  
  #a similar command is used to extract the lower bounds.
  
rm(work) #get rid of this no longer needed object


