### Name: pumaDE
### Title: Calculate differential expression between conditions
### Aliases: pumaDE
### Keywords: manip

### ** Examples

        data(affybatch.example)
        varLabels(affybatch.example) <- c("level")
        pData(affybatch.example) <- data.frame("level"=c("twenty","twenty","ten")
            , "batch"=c("A","B","A"), row.names=rownames(pData(affybatch.example)))
        eset_mmgmos <- mmgmos(affybatch.example)
        eset_comb <- pumaComb(eset_mmgmos)
        pumaDEResults <- pumaDE(eset_comb)

        topGeneIDs(pumaDEResults,6) # Gives probeset identifiers
        topGenes(pumaDEResults,6) # Gives row numbers
        statistic(pumaDEResults)[topGenes(pumaDEResults,6),] # PPLR scores of top six genes
        FC(pumaDEResults)[topGenes(pumaDEResults,6),] # Fold-change of top six genes



