### Name: robustSvd
### Title: Alternating L1 Singular Value Decomposition
### Aliases: robustSvd
### Keywords: algebra

### ** Examples

## Load a complete sample metabolite data set and mean center the data
data(metaboliteDataComplete)
mdc <- scale(metaboliteDataComplete, center=TRUE, scale=FALSE)
## Now create 5
cond   <- runif(length(mdc)) < 0.05;
mdcOut <- mdc
mdcOut[cond] <- 10

## Now we do a conventional SVD and a robustSvd on both, the original and the 
## data with outliers.
resSvd       <- svd(mdc)
resSvdOut    <- svd(mdcOut)
resRobSvd    <- robustSvd(mdc)
resRobSvdOut <- robustSvd(mdcOut)

## Now we plot the results for the original data against those with outliers
## We can see that robustSvd is hardly effected by the outliers.
plot(resSvd$v[,1], resSvdOut$v[,1])
plot(resRobSvd$v[,1], resRobSvdOut$v[,1])



