###################################################
### chunk number 1: 
###################################################
options(width=70)
require(ontoTools, quietly=TRUE)
library(KEGG)
#require(KEGG, quietly=TRUE)


###################################################
### chunk number 2: keggdemo
###################################################
KPL <- eapply(KEGGPATHID2NAME, function(x)x)
GDI_KEGGPATH <- new("nomenclature", name="KEGGPATH",
 provenance=new("provStruct", 
 URI="ftp://ftp.genome.ad.jp/pub/kegg/pathways/map_title.tab", 
 captureDate="June 30 2004", comment="Rel 30.0"), 
 inMappings=c("LL2KEGGmap.hsa", "LL2KEGGmap.rno"),
 terms=names(KPL), definitions=as.character(unlist(KPL)))
GDI_KEGGPATH


###################################################
### chunk number 3: lkGDINCI
###################################################
data(GDI_NCIThesaurus)
GDI_NCIThesaurus


###################################################
### chunk number 4: lkpar
###################################################
mpar <- parents("Mesna", GDI_NCIThesaurus)
mpar
children( mpar, GDI_NCIThesaurus )


###################################################
### chunk number 5: lkHER
###################################################
substring(grep("HER-2", GDI_NCIThesaurus),1,70)


###################################################
### chunk number 6: lkdef
###################################################
getDefs("Mesna", GDI_NCIThesaurus)


###################################################
### chunk number 7: 
###################################################
data(SGDIvocab)
SGDIvocab@terms


###################################################
### chunk number 8: loadRswub eval=FALSE
###################################################
## library(Rswub)


###################################################
### chunk number 9: useRswub eval=FALSE
###################################################
## omod <- readSWModel("http://www.biostat.harvard.edu/~carey/SGDI.owl", asURL=TRUE)


###################################################
### chunk number 10: local eval=FALSE
###################################################
## omod <- readSWModel("/home/stvjc/Protege_3.0_beta/SGDI.owl")
## omod@documentName <- "http://www.biostat.harvard.edu/~carey/SGDI.owl"


###################################################
### chunk number 11: lkmod eval=FALSE
###################################################
## omod


###################################################
### chunk number 12: lkont eval=FALSE
###################################################
## somod <- getSplits(omod)
## names(somod)


###################################################
### chunk number 13: lkmt eval=FALSE
###################################################
## somod$bysub$NCI_Meta_tag


###################################################
### chunk number 14: lkbc eval=FALSE
###################################################
## somod$bypred$NCI_Meta_tag


###################################################
### chunk number 15: lknom
###################################################
data(SGDIvocab)
SGDIvocab


