###################################################
### chunk number 1: setup
###################################################
DontRun <- TRUE


###################################################
### chunk number 2: getLLtags
###################################################
library(humanLLMappings)
lltags <- ls(env=humanLLMappingsLL2GO)


###################################################
### chunk number 3: countTags
###################################################
print(length(lltags))


###################################################
### chunk number 4: getAnnot
###################################################
kvmap <- list()
hllgoEnv <- new.env(hash=TRUE)
library(GO.db)


###################################################
### chunk number 5: getGOMF
###################################################
GOtags <- ls(GOTERM)
library(Biobase)
library(annotate)
GOlabs <- mget(GOtags, GOTERM)
GOMFtags <- GOtags[sapply(GOlabs,Ontology)=="MF"]
#GOMFterms <- unlist(mget(GOMFtags,env=GOTERM))
#ntags <- length(GOMFtags)
#if (any(duplicated(GOMFterms)))
# {
# dups <- (1:ntags)[duplicated(GOMFterms)]
# GOMFterms[dups] <- paste(GOMFterms[dups],".2",sep="")
# }
#names(GOMFterms) <- GOMFtags



###################################################
### chunk number 6: iterateLoci
###################################################
if (!(DontRun)) {
 cat(length(lltags))
 for (i in 1:length(lltags))
  {
  if (i %% 200 == 0) cat(i)
  tmp <- get(lltags[i], env=humanLLMappingsLL2GO)
  tmp = gsub("@.*$","", tmp)
  tmp <- tmp[ tmp %in% GOMFtags ]
  if (length(tmp)>0) 
     {
     kvmap[[ lltags[i] ]]  <- tmp
     assign( lltags[i], tmp, env=hllgoEnv )
     }
  }
}


###################################################
### chunk number 7: getGOtargets
###################################################
if (!(DontRun)) {
 print(length(kvmap))
 gotargs <- sort(unique(unlist(kvmap)))
 llused <- names(kvmap)
 print(length(gotargs))
}



###################################################
### chunk number 8: makeNamedSparse
###################################################
library(ontoTools)
if (!DontRun) {
LL2GOMFooMap.1.15 <- otkvEnv2namedSparse( llused, gotargs, hllgoEnv )
save(LL2GOMFooMap.1.15, file="LL2GOMFooMap1.15.rda", compress=TRUE)
save.image()
}
if (DontRun) data(LL2GOMFooMap.1.15)


###################################################
### chunk number 9: gogr
###################################################
if (!DontRun) {goMFgraph.1.15 <- buildGOgraph()} else data(goMFgraph.1.15)
save.image()


###################################################
### chunk number 10: rDAG
###################################################
go1.15DAG <- new("rootedDAG", root="GO:0003674", DAG=goMFgraph.1.15)
GOMF1.15 <- new("ontology", name="GOMF",  version="bioc 2.0", rDAG=go1.15DAG)
if (!DontRun) {goMFamat.1.15 <- accessMat(GOMF1.15)} else {data(goMFamat.1.15)}
save.image()


###################################################
### chunk number 11: makeOOC
###################################################
LL2GOMFooc1.15 <- new("OOC", ontology=GOMF1.15, OOmap=LL2GOMFooMap.1.15)
save.image()



###################################################
### chunk number 12: conceptProbs
###################################################
if (!DontRun) LL2GOMFcp.1.15 <- conceptProbs( ooc=LL2GOMFooc1.15, acc=goMFamat.1.15 )
save.image()



