### Name: prune.graph
### Title: Prunes spurious edges in a phenotypic hierarchy
### Aliases: prune.graph
### Keywords: graphs

### ** Examples

    # a transitively closed core with two spurious edges
    g <- matrix(0,5,5)
    g[1,2] <- 1
    g[2,c(3,4)] <- 1
    g[3,4] <- 1
    g[4,5] <- 1
    dimnames(g) <- list(LETTERS[1:5],LETTERS[1:5])
    g <- as(g,"graphNEL")
    
    # prune graph
    gP <- prune.graph(g)
    
    # plot
    par(mfrow=c(1,2))
    plot(g,main="two spurious edges")
    plot(gP$graph,main="pruned")
    
    



