### Name: pretty.dend
### Title: Draw hierarchical tree of gene expression data with a colorbar
###   for numerous class vectors
### Aliases: pretty.dend
### Keywords: hplot manip

### ** Examples

  data(khan)
  logkhan<-log2(khan$train)
  pretty.dend(logkhan, classvec=khan$train.classes, labels=khan$train.classes)
 
 # Get a character vector which defines which khan samples are cell lines or tissue sample
  cellType = sapply((strsplit(colnames(khan$train), "\.")), function(x) substr(x[[2]],1,1))
  khanAnnot= cbind(khan$train.classes,cellType)
  print(khanAnnot[1:3,])

# Add 2 color bar, one for cancer subtype, another for cell type under dendrogram
  pretty.dend(logkhan, classvec=khanAnnot, covars = c(1,2), labels=khan$train.classes)



