###################################################
### chunk number 1: one
###################################################
library(gaga)
set.seed(10)
n <- 100; m <- c(6,6)
a0 <- 25.5; nu <- 0.109
balpha <- 1.183; nualpha <- 1683
probpat <- c(.95,.05)
xsim <- sim.gg(n,m,p.de=probpat[2],a0,nu,balpha,nualpha)


###################################################
### chunk number 2: two
###################################################
names(xsim)
dim(xsim$x)
dim(xsim$a)
dim(xsim$l)


###################################################
### chunk number 3: fig1aplot
###################################################
plot(density(xsim$x),xlab='Expression levels',main='')


###################################################
### chunk number 4: fig1bplot
###################################################
plot(xsim$l,xsim$a,xlab='Mean',ylab='1/sqrt(CV)')


###################################################
### chunk number 5: fig1a
###################################################
plot(density(xsim$x),xlab='Expression levels',main='')


###################################################
### chunk number 6: fig1b
###################################################
plot(xsim$l,xsim$a,xlab='Mean',ylab='1/sqrt(CV)')


###################################################
### chunk number 7: three
###################################################
groups <- rep(1:2,each=5)
patterns <- matrix(c(0,0,0,1),2,2)
patterns


###################################################
### chunk number 8: four
###################################################
patterns <- matrix(c(0,0,0,1),2,2)
ggfit <- fit.gg(xsim$x[,c(-6,-12)],groups,patterns=patterns,nclust=1,trace=FALSE)


###################################################
### chunk number 9: fig3plot
###################################################
plot(ggfit$mcmc)


###################################################
### chunk number 10: fig3
###################################################
plot(ggfit$mcmc)


###################################################
### chunk number 11: five
###################################################
ggfit <- parest(ggfit,x=xsim$x[,c(-6,-12)],groups,burnin=100,alpha=.05)
ggfit
ggfit$ci


###################################################
### chunk number 12: six
###################################################
ggfit.eb <- fit.gg(xsim$x[,c(-6,-12)],groups,patterns=patterns,method='EBayes')  
ggfit.eb <- parest(ggfit.eb,x=xsim$x[,c(-6,-12)],groups,alpha=.05)
ggfit.eb


###################################################
### chunk number 13: seven
###################################################
dim(ggfit$pp)
ggfit$pp[1,]
ggfit.eb$pp[1,]


###################################################
### chunk number 14: fig4aplot
###################################################
 checkfit(ggfit,x=xsim$x[,c(-6,-12)],groups,type='data',main='')


###################################################
### chunk number 15: fig4bplot
###################################################
checkfit(ggfit,x=xsim$x[,c(-6,-12)],groups,type='shape',main='')


###################################################
### chunk number 16: fig4cplot
###################################################
checkfit(ggfit,x=xsim$x[,c(-6,-12)],groups,type='mean',main='')


###################################################
### chunk number 17: fig4dplot
###################################################
checkfit(ggfit,x=xsim$x[,c(-6,-12)],groups,type='shapemean',main='',xlab='Mean',ylab='1/sqrt(CV)')


###################################################
### chunk number 18: fig4a
###################################################
 checkfit(ggfit,x=xsim$x[,c(-6,-12)],groups,type='data',main='')


###################################################
### chunk number 19: fig4b
###################################################
checkfit(ggfit,x=xsim$x[,c(-6,-12)],groups,type='shape',main='')


###################################################
### chunk number 20: fig4c
###################################################
checkfit(ggfit,x=xsim$x[,c(-6,-12)],groups,type='mean',main='')


###################################################
### chunk number 21: fig4d
###################################################
checkfit(ggfit,x=xsim$x[,c(-6,-12)],groups,type='shapemean',main='',xlab='Mean',ylab='1/sqrt(CV)')


###################################################
### chunk number 22: eight
###################################################
d <- findgenes(ggfit,xsim$x[,c(-6,-12)],groups,fdrmax=.05,parametric=TRUE)
d.nonpar <- findgenes(ggfit,xsim$x[,c(-6,-12)],groups,fdrmax=.05,parametric=FALSE,B=1000)
dtrue <- (xsim$l[,1]!=xsim$l[,2])
table(d$d,dtrue)
table(d.nonpar$d,dtrue)


###################################################
### chunk number 23: fig5plot
###################################################
plot(d.nonpar$fdrest,type='l',xlab='Bayesian FDR',ylab='Estimated frequentist FDR')


###################################################
### chunk number 24: fig1
###################################################
plot(d.nonpar$fdrest,type='l',xlab='Bayesian FDR',ylab='Estimated frequentist FDR')


###################################################
### chunk number 25: nine
###################################################
pred1 <- classpred(ggfit,xnew=xsim$x[,6],x=xsim$x[,c(-6,-12)],groups,ngene=50,prgroups=c(.5,.5))
pred2 <- classpred(ggfit,xnew=xsim$x[,12],x=xsim$x[,c(-6,-12)],groups,ngene=50,prgroups=c(.5,.5))
pred1
pred2


