### Name: getTopTable
### Title: Generate the hit list from a scored cellHTS object
### Aliases: getTopTable
### Keywords: manip

### ** Examples

    data(KcViabSmall)
    xn <- normalizePlates(KcViabSmall, scale="multiplicative", log=FALSE, method="median", varianceAdjust="none") 
    xsc <- scoreReplicates(xn, sign="-", method="zscore")
    xsc <- summarizeReplicates(xsc, summary="mean")
    out <- getTopTable(cellHTSlist=list("raw"=KcViabSmall, "normalized"=xn, "scored"=xsc), file=tempfile())



