###################################################
### chunk number 1: 
###################################################
##Use affybatch.example in affy package
library(RefPlus)
library(affydata)
##data(affybatch.example)
data(Dilution)
sampleNames(Dilution)


###################################################
### chunk number 2: 
###################################################
##Calculate RMA intensities using the rma function.
Ex0<-exprs(rma(Dilution))


###################################################
### chunk number 3: 
###################################################
##Background correct, estimate the probe effects, and calculate the 
##RMA intensities using rma.para function.
Para<-rma.para(Dilution[,1:3],bg=TRUE,exp=TRUE)
Ex1 <- Para[[3]]


###################################################
### chunk number 4: 
###################################################
##Calculate the RMA+ intensity using rmaplus function. 
##Ex2 <- rmaplus(affybatch.example, rmapara=Para, bg = TRUE)
Ex2 <- rmaplus(Dilution, rmapara=Para, bg = TRUE)


###################################################
### chunk number 5: 
###################################################
par(mfrow=c(2,2))
plot(Ex0[,1],Ex2[,1],pch=".",main=sampleNames(Dilution)[1])
plot(Ex0[,2],Ex2[,2],pch=".",main=sampleNames(Dilution)[2])
plot(Ex0[,3],Ex2[,3],pch=".",main=sampleNames(Dilution)[3])
plot(Ex0[,4],Ex2[,4],pch=".",main=sampleNames(Dilution)[4])


###################################################
### chunk number 6: 
###################################################
Para2 <- rma.para(Dilution[,2:4],bg=TRUE,exp=TRUE)
Ex3 <- rmaplus(Dilution, rmapara=Para2, bg = TRUE)


###################################################
### chunk number 7: 
###################################################
Ex4 <- (Ex2+Ex3)/2


###################################################
### chunk number 8: 
###################################################
par(mfrow=c(2,2))
plot(Ex0[,1],Ex4[,1],pch=".",main=sampleNames(Dilution)[1])
plot(Ex0[,2],Ex4[,2],pch=".",main=sampleNames(Dilution)[2])
plot(Ex0[,3],Ex4[,3],pch=".",main=sampleNames(Dilution)[3])
plot(Ex0[,4],Ex4[,4],pch=".",main=sampleNames(Dilution)[4])


###################################################
### chunk number 9: 
###################################################
sqrt(mean((Ex0-Ex2)^2))
sqrt(mean((Ex0-Ex3)^2))


###################################################
### chunk number 10: 
###################################################
sqrt(mean((Ex0-Ex4)^2))


