### Name: FDR
### Title: Compute FDR for general scenarios
### Aliases: FDR CDF CDFmix FDR.paired CDF.paired CDFmix.paired
### Keywords: utilities distribution

### ** Examples

# FDR for H0: 'log fold change is zero'
#     vs. H1: 'log fold change is -1 or 1' 
#             (ie two-fold up- or down regulation) 
FDR(1:6, n1=10, n2=10, pmix=0.90, D0=0, p0=1, 
    D1=c(-1,1), p1=c(0.5, 0.5), sigma=1)

# Include small log fold changes in the H0
# Naturally, this increases the FDR
FDR(1:6, n1=10, n2=10, pmix=0.90, D0=c(-0.25,0, 0.25), p0=c(1/3,1/3,1/3), 
    D1=c(-1,1), p1=c(0.5, 0.5), sigma=1)

# Consider an asymmetric alternative
# 10 percent of the regulated genes are assumed to be four-fold upregulated
FDR(1:6, n1=10, n2=10, pmix=0.90, D0=0, p0=1, 
    D1=c(-1,1,2), p1=c(0.45, 0.45, 0.1), sigma=1)



