###################################################
### chunk number 1: 1 eval=FALSE
###################################################
## library(GeneticsBase)
## setwd(file.path(.path.package("GeneticsBase"), "data"))


###################################################
### chunk number 2: 2 eval=FALSE
###################################################
## ALZH <- readGenes(gfile="ALZH.ped", gformat="fbat.ped")


###################################################
### chunk number 3: 3 eval=FALSE
###################################################
## CAMP <- readGenes(gfile="CAMP.ped", gformat="fbat.ped",
##                   pfile="CAMPZ.phe", pformat="fbat.phe")


###################################################
### chunk number 4: 4 eval=FALSE
###################################################
## hapmapchr1 <- readGenes(gfile="hapmapchr1.ped", gformat="hapmap")


###################################################
### chunk number 5: 5 eval=FALSE
###################################################
## PfizerExample <- readGenes.pfizer("PfizerExample.txt", format="Listing")


###################################################
### chunk number 6: 6 eval=FALSE
###################################################
## PerlegenExample <- readGenes("PerlegenExample.txt", gformat="perlegen")


###################################################
### chunk number 7: 7
###################################################
library(GeneticsBase)
data(CAMP)


###################################################
### chunk number 8: 8
###################################################
upper <- function(x)
{
  tmp <- capture.output(print(x))
  cat(paste(head(tmp, n=15), collapse="\n"))
  cat("\n")
  cat("\n...\n")
}


###################################################
### chunk number 9: 9
###################################################
CAMP


###################################################
### chunk number 10: 10 eval=FALSE
###################################################
## pdata <- sampleInfo(CAMP)
## summary(pdata)


###################################################
### chunk number 11: 11
###################################################
pdata <- sampleInfo(CAMP)
upper(summary(pdata))


###################################################
### chunk number 12: 12 eval=FALSE
###################################################
## alleleSummary(CAMP)


###################################################
### chunk number 13: 13
###################################################
upper(alleleSummary(CAMP))


###################################################
### chunk number 14: 14 eval=FALSE
###################################################
## genotypeSummary(CAMP)


###################################################
### chunk number 15: 15
###################################################
upper(genotypeSummary(CAMP))


###################################################
### chunk number 16: 16
###################################################
# get descriptive statistics for markers
#desMarkers(CAMP, founderOnly=T)


###################################################
### chunk number 17: 17 eval=FALSE
###################################################
## ld <- LD(CAMP)
## ld


###################################################
### chunk number 18: 18
###################################################
ld <- LD(CAMP)
upper(ld)


###################################################
### chunk number 19: 19
###################################################
plot(ld)


###################################################
### chunk number 20: 20
###################################################
# visualize r^2 matrix
r2<-t(ld@"R^2")
diag(r2)<-1
LDView(r2, labRow=markerNames(CAMP))


###################################################
### chunk number 21: 21
###################################################
aS <- alleleSummary(CAMP)
txt(aS, file="CAMP_alleleSummary.txt")


###################################################
### chunk number 22: 22 eval=FALSE
###################################################
## aS <- alleleSummary(CAMP)
## latex(aS)


###################################################
### chunk number 23: 23
###################################################
aS <- alleleSummary(CAMP)
latex(aS, floating=FALSE)



###################################################
### chunk number 24: 24 eval=FALSE
###################################################
## gs <- genotypeSummary(CAMP[-2,])
## latex(gS) # drop ALR2 SSLP so table fits on page


###################################################
### chunk number 25: 25
###################################################
gS <- genotypeSummary(CAMP[-2,])
latex(gS, floating=FALSE) # drop ALR2 SSLP so table fits on page


###################################################
### chunk number 26: 26 eval=FALSE
###################################################
## ld <- LD(CAMP)
## latex(ld)


###################################################
### chunk number 27: 27
###################################################
ld <- LD(CAMP)
latex(ld, floating=FALSE)


###################################################
### chunk number 28: 28
###################################################
plot(ld)


###################################################
### chunk number 29: 29
###################################################
PGtables(CAMP, filename="CAMP", sep="_", format="html")


###################################################
### chunk number 30: 30
###################################################
alleleSummary(CAMP, by='sex') 


###################################################
### chunk number 31: 31 eval=FALSE
###################################################
## library(GeneticsBase)
## 
## data(CAMP)
## 
## ## HTML Output
## PGtables(CAMP, filename="test", format="html")
## 
## ## LaTex Output
## PGtables(CAMP, filename="test", format="latex")


