### Name: cghRaw
### Title: Class to contain and describe raw or normalized array
###   comparative genomic hybridization data.
### Aliases: class:cghRaw cghRaw cghRaw-class copynumber,cghRaw-method
###   copynumber<-,cghRaw,matrix-method chromosomes,cghRaw-method
###   bpstart,cghRaw-method bpend,cghRaw-method initialize,cghRaw-method
###   plot,cghRaw,missing-method
### Keywords: classes

### ** Examples

# create an instance of cghRaw
new("cghRaw")

# create an instance of cghRaw from a dataframe
data(Wilting)
rawcgh <- make_cghRaw(Wilting)

# plot the first sample
plot(rawcgh[,1])
# first three chromosomes
plot(rawcgh[chromosomes(rawcgh)==1,1])

# get the copynumber values of the third and fourth sample
log2ratios <- copynumber(rawcgh[,3:4])

# get the names of the samples
sampleNames(rawcgh)

# get the names of the array elements
featureNames(rawcgh)



