### Name: cghCall
### Title: Class to contain and describe called array comparative genomic
###   hybridization data.
### Aliases: class:cghCall cghCall cghCall-class copynumber,cghCall-method
###   copynumber<-,cghCall,matrix-method segmented,cghCall-method
###   segmented<-,cghCall,matrix-method calls,cghCall-method
###   calls<-,cghCall,matrix-method probloss,cghCall-method
###   probloss<-,cghCall,matrix-method probnorm,cghCall-method
###   probnorm<-,cghCall,matrix-method probgain,cghCall-method
###   probgain<-,cghCall,matrix-method probamp,cghCall-method
###   probamp<-,cghCall,matrix-method chromosomes,cghCall-method
###   bpstart,cghCall-method bpend,cghCall-method initialize,cghCall-method
###   plot,cghCall,missing-method plot.summary,cghCall,missing-method
### Keywords: classes

### ** Examples

# create an instance of cghCall
new("cghCall")

# create an instance of cghCall through this-is-escaped-codenormal-bracket153bracket-normal
## Not run: 
##D    data(Wilting)
##D    rawcgh <- make_cghRaw(Wilting)
##D    cghdata <- preprocess(cghdata)
##D    normalized <- normalize(cghdata)
##D    segmented <- segmentData(normalized)
##D    called <- CGHcall(segmented)
##D 
##D    # plot the first sample
##D    plot(called[,1])
##D    # plot the first chromosome of the first sample
##D    plot(called[chromosomes(called)==1,1])
##D 
##D    # get the copynumber values of the third and fourth sample
##D    log2ratios <- copynumber(called[,3:4])
##D 
##D    # get the names of the samples
##D    sampleNames(called)
##D 
##D    # get the names of the array elements
##D    featureNames(called)
## End(Not run)



