### Name: PDict-class
### Title: PDict objects
### Aliases: class:ACtree ACtree-class ACtree length,ACtree-method
###   show,ACtree-method [,ACtree-method as.matrix,ACtree-method
###   initialize,ACtree-method class:Dups Dups-class Dups
###   length,Dups-method duplicated,Dups-method class:PDict PDict-class
###   patternFrequency class:CWdna_PDict CWdna_PDict-class CWdna_PDict
###   initialize,CWdna_PDict-method length,CWdna_PDict-method
###   width,CWdna_PDict-method names,CWdna_PDict-method
###   show,CWdna_PDict-method duplicated,CWdna_PDict-method
###   patternFrequency,CWdna_PDict-method class:TBdna_PDict
###   TBdna_PDict-class TBdna_PDict initialize,TBdna_PDict-method
###   head,TBdna_PDict-method tail,TBdna_PDict-method
###   show,TBdna_PDict-method duplicated,TBdna_PDict-method
###   patternFrequency,TBdna_PDict-method PDict PDict,character-method
###   PDict,DNAStringSet-method PDict,XStringViews-method PDict,AsIs-method
### Keywords: methods classes

### ** Examples

  ## Preprocessing a constant width DNA dictionary
  library(drosophila2probe)
  dict0 <- drosophila2probe$sequence   # The input sequences.
  length(dict0)                        # Hundreds of thousands of patterns.
  unique(nchar(dict0))                 # Patterns are 25-mers.
  dict0[1:5]
  pdict0 <- PDict(dict0)               # Store the input dictionary into a
                                       # PDict object (preprocessing).
  pdict0
  class(pdict0)
  length(pdict0)                       # Same as length(dict0).
  width(pdict0)                        # The number of chars per pattern.
  sum(duplicated(pdict0))
  table(patternFrequency(pdict0))      # 9 patterns are repeated 3 times.

  ## Creating a constant width DNA dictionary by truncating the input
  ## sequences
  dict1 <- c("ACNG", "GT", "CGT", "AC")
  pdict1a <- PDict(dict1, tb.end=2, drop.tail=TRUE)
  pdict1a
  class(pdict1a)
  length(pdict1a)
  width(pdict1a)
  duplicated(pdict1a)
  patternFrequency(pdict1a)

  ## Preprocessing a Trusted Prefix DNA dictionary
  pdict1b <- PDict(dict1, tb.end=2)
  pdict1b
  class(pdict1b)
  length(pdict1b)
  width(pdict1b)
  head(pdict1b)
  tail(pdict1b)



