### Name: IRanges-class
### Title: IRanges and NormalIRanges objects
### Aliases: class:IRanges IRanges-class IRanges class:UnlockedIRanges
###   UnlockedIRanges-class UnlockedIRanges class:Views Views-class Views
###   class:LockedIRanges LockedIRanges-class LockedIRanges
###   class:NormalIRanges NormalIRanges-class NormalIRanges
###   length,IRanges-method start,IRanges-method width width,IRanges-method
###   end,IRanges-method names,IRanges-method desc isNormal
###   isNormal,IRanges-method whichFirstNotNormal
###   whichFirstNotNormal,IRanges-method isEmpty isEmpty,IRanges-method
###   isEmpty,NormalIRanges-method max,NormalIRanges-method
###   min,NormalIRanges-method initialize,IRanges-method
###   initialize,Views-method initialize,NormalIRanges-method IRanges
###   coerce,IRanges,NormalIRanges-method
###   coerce,UnlockedIRanges,NormalIRanges-method
###   coerce,Views,NormalIRanges-method
###   coerce,LockedIRanges,NormalIRanges-method
###   as.data.frame,IRanges-method show,IRanges-method [,IRanges-method
###   [<-,IRanges-method duplicated,IRanges-method as.matrix,IRanges-method
###   start<- start<-,UnlockedIRanges-method width<-
###   width<-,UnlockedIRanges-method end<- end<-,UnlockedIRanges-method
###   names<-,IRanges-method desc<- update,UnlockedIRanges-method first
###   first,IRanges-method last last,IRanges-method
### Keywords: methods classes

### ** Examples

  x <- IRanges(start=c(2:-1, 13:15), width=c(0:3, 2:0))
  x
  length(x)
  start(x)
  width(x)
  end(x)
  isEmpty(x)
  as.data.frame(x)
  as.matrix(x)

  ## Subsetting:
  x[4:2]                  # 3 ranges
  x[-1]                   # 6 ranges
  x[FALSE]                # 0 range
  x0 <- x[width(x) == 0]  # 2 ranges
  isEmpty(x0)

  ## Unlock the IRanges instance and use replacement methods to slide
  ## or resize its elements:
  x <- as(x, "UnlockedIRanges")
  width(x) <- width(x) * 2  + 1  # resize elements
  x
  start(x) <- end(x)             # slide elements
  x
  start(x)[4] <- end(x)[4]       # slide the 4th element
  x
  end(x)[1] <- start(x)[3]       # slide the first element
  x
  width(x) <- c(2, 0)            # resize elements
  x
  duplicated(x)

  ## Name the elements:
  names(x)
  names(x) <- c("range1", "range2")
  x
  x[names(x) == ""]  # 5 ranges
  x[names(x) != ""]  # 2 ranges

  ## Using an IRanges object for storing a big set of ranges is more
  ## efficient than using a standard R data frame:
  N <- 2000000L  # nb of ranges
  W <- 180L      # width of each range
  start <- 1L
  end <- 50000000L
  set.seed(777)
  range_starts <- sort(sample(end-W+1L, N))
  range_widths <- rep.int(W, N)
  ## Instantiation is faster
  system.time(x <- IRanges(start=range_starts, width=range_widths))
  system.time(y <- data.frame(start=range_starts, width=range_widths))
  ## Subsetting is faster
  system.time(x16 <- x[c(TRUE, rep.int(FALSE, 15))])
  system.time(y16 <- y[c(TRUE, rep.int(FALSE, 15)), ])
  ## Internal representation is more compact
  object.size(x16)
  object.size(y16)

  ## Normality:
  isNormal(x16)                        # FALSE
  if (interactive())
      x16 <- as(x16, "NormalIRanges")  # Error!
  whichFirstNotNormal(x16)             # 57
  isNormal(x16[1:56])                  # TRUE
  xx <- as(x16[1:56], "NormalIRanges")
  class(xx)
  max(xx)
  min(xx)



