### Name: make.design
### Title: Create a Design Matrix
### Aliases: make.design
### Keywords: array

### ** Examples

target<-data.frame(drug=(c(rep("A",4),rep("B",4),rep("C",4))), 
gender=factor(c(rep("M",6),rep("F",6))), 
group=factor(rep(c(1,2,3),4)))
                         
#To create a design matrix using "drug", "gender" as covariates
design1<-make.design(target, c("drug","gender"))
        
#To create a design matrix by using "drug","gender","group" as covariates, 
#and consider the interaction effect of "drug" and "group"
design2<-make.design(target, c("drug","gender", "group"), int=c(1,3))



