### Name: heatplot
### Title: Draws heatmap with dendrograms.
### Aliases: heatplot
### Keywords: hplot manip

### ** Examples

data(khan)

heatplot(khan$train[1:30,], cols.default=FALSE, lowcol="white", highcol="red")
heatplot(khan$train[1:26,], labCol = c(64:1), labRow=LETTERS[1:26])

heatplot(khan$train[1:26,], classvec=khan$train.classes)

if (require(ade4, quiet = TRUE)) {
res<-ord(khan$train, ord.nf=5)  # save 5 components from correspondence analysis
khan.coa = res$ord
}

# Provides a view of the components of the Correspondence analysis (gene projection) in the lines (row)
heatplot(khan.coa$li)    # first 5 components
heatplot(khan.coa$li, margins=c(4,20))  # Change the margin size. The default is c(5,5)

  
# Sample projection (columns)
# See that the difference between tissues and cell line samples are defined in the first axis.

heatplot(khan.coa$co,classvec2=khan$train.classes, cols.default=FALSE, lowcol="blue", dend="row", scale="none")




