### Name: probeset.to.probe
### Title: Use the X:MAP database to translate between genes, transcripts,
###   exons, probesets and probes
### Aliases: probeset.to.probe probeset.to.exon probeset.to.transcript
###   probeset.to.gene exon.to.probeset exon.to.transcript exon.to.gene
###   transcript.to.gene transcript.to.exon transcript.to.probeset
###   gene.to.transcript gene.to.exon gene.to.probeset symbol.to.probeset
###   symbol.to.gene
### Keywords: misc

### ** Examples
 
  ## Not run: 
##D library(exonmap)
##D #reading arrays etc.
##D #x  <- read.exon()
##D 
##D data(exonmap)
##D xmapDatabase("Human")
##D 
##D cmp <- pc(x.rma,"group",c("a","b"))
##D 
##D fc.r <-fc(cmp)
##D tt.r <-tt(cmp)
##D 
##D # Only a test! - and x doesn't have many genes in it!
##D keep.fc <- abs(fc.r) > 1
##D keep.tt <- tt.r < 0.05
##D 
##D keep <- keep.fc & keep.tt
##D 
##D ps <- featureNames(x.rma)[keep]
##D 
##D # OK, test mapping functions
##D 
##D ex <- probeset.to.exon(ps)
##D tr <- probeset.to.transcript(ps)
##D ge <- probeset.to.gene(ps)
##D 
##D probeset.to.exon(ps,list.out=TRUE)
##D probeset.to.transcript(ps,list.out=TRUE)
##D probeset.to.gene(ps,list.out=TRUE)
##D 
##D exon.to.transcript(ex)
##D exon.to.gene(ex)
##D exon.to.probeset(ex)
##D 
##D transcript.to.gene(tr)
##D transcript.to.exon(tr)
##D transcript.to.probeset(tr)
##D 
##D gene.to.transcript(ge)
##D gene.to.exon(ge)
##D gene.to.probeset(ge)
##D 
##D gds <- gene.details(ge)
##D trs <- transcript.details(tr)
##D exs <- exon.details(ex)
##D pss <- probeset.stats(ps)
##D 
##D symbol.to.gene(unlist(gds[,13]))
##D symbol.to.probeset(unlist(gds[,13]))
##D 
##D genes.in.range(1,100000,1,1)
##D genes.in.range(1,100000,-1,1)
##D 
##D transcripts.in.range(1,100000,1,1)
##D transcripts.in.range(1,100000,-1,1)
##D 
##D exons.in.range(1,100000,1,1)
##D exons.in.range(1,100000,-1,1)
##D 
##D probesets.in.range(1,100000,1,1)
##D probesets.in.range(1,100000,-1,1)
##D 
##D probeset.stats(ps)
## End(Not run)



