### Name: coerce
### Title: Convert Data Objects
### Aliases: convert coerce,RGList,marrayRaw-method
###   coerce,marrayRaw,RGList-method coerce,MAList,marrayNorm-method
###   coerce,marrayNorm,MAList-method coerce,RGList,exprSet-method
###   coerce,marrayRaw,NChannelSet-method coerce,RGList,NChannelSet-method
###   coerce,MAList,exprSet-method coerce,MAList,ExpressionSet-method
###   coerce,marrayRaw,exprSet-method
###   coerce,marrayNorm,ExpressionSet-method
###   coerce,marrayNorm,exprSet-method
### Keywords: classes data

### ** Examples

##first set up some fake intensity matrices
testRed = matrix(rnorm(5*2),5,2, 
  dimnames=list(paste("gene",1:5, sep=""), c("S1", "S2")))
testGreen = matrix(rnorm(5*2),5,2, 
  dimnames=list(paste("gene",1:5, sep=""), c("S1", "S2")))

##some sample/target info
testTarget = data.frame(slide=c("S1", "S2"), Cy3=c("T", "C"),
  Cy5=c("C", "T"), row.names=c("S1", "S2"))

maT = new("marrayInfo", maLabels=c("S1", "S2"),
  maInfo= testTarget)

##now create instances and convert
x <- new("RGList")
x$R = testRed
x$G = testGreen
y <- as(x,"marrayRaw")
z <- as(x, "NChannelSet")

x <- new("marrayRaw")
x@maGf <- testGreen
x@maRf <- testRed
x@maTargets = maT
y <- as(x,"RGList")
z <- as(x, "NChannelSet")

x <- new("MAList")
y <- as(x,"marrayNorm")

##we construct a reasonably complete fake, small 
##instance of the marrayNorm class
x <- new("marrayNorm")
x@maM <- testRed
x@maA <- testGreen
maTargets(x) = maT
y <- as(x,"MAList")
y <- as(x, "ExpressionSet")

x <- new("MAList")
x$M <- testRed
x$A <- testGreen
x$targets = testTarget
y <- as(x,"ExpressionSet")



