### Name: getSnpAnnotation
### Title: Retrieves SNP-level annotation
### Aliases: getSnpAnnotation getSnpAnnotation,SnpLevelSet-method
###   getSnpAnnotation,SnpCallSet-method
###   getSnpAnnotation,SnpCopyNumberSet-method
###   getSnpAnnotation,oligoSnpSet-method
### Keywords: methods manip

### ** Examples


##Default method for adding SNP-level annotation
  data(sample.snpset)
## Not run: 
##D ##Requires pd.mapping50k.xba240 annotation package
##D   snp.annotation <- getSnpAnnotation(sample.snpset)
##D   snp.annotation
##D   class(snp.annotation)
##D   identical(featureNames(obj), featureNames(snp.annotation))
##D   featureData(sample.snpset) <- snp.annotation
##D   fvarLabels(sample.snpset)
## End(Not run)

##Using NetAffx annotation (already saved as a data.frame)
## Not run: 
##D   
##D   try(load(url("http://biostat.jhsph.edu/~iruczins/publications/sm/2006.scharpf.bioinfo/mapping/mapping50kXba240.rda")))
##D   reorderRows <- match(featureNames(sample.snpset), as.character(mapping50kXba240$Probe.Set.ID))
##D   netaffx.annotation <- mapping50kXba240[reorderRows, ]
##D   fD <- as(netaffx.annotation, "AnnotatedDataFrame")
##D   featureData(sample.snpset) <- fD
##D   varLabels(featureData(sample.snpset))
## End(Not run)



