### Name: OutlierD
### Title: Outlier dectection using quantile regression on the M-A
###   scatterplots of high-throughput data
### Aliases: OutlierD
### Keywords: models

### ** Examples


data(lcms)
x <- log2(lcms) #log2-tranformation, do normalization if necessary

fit1 <- OutlierD(x1=x[,1], x2=x[,2], method="constant")
fit2 <- OutlierD(x1=x[,1], x2=x[,2], method="linear")
fit3 <- OutlierD(x1=x[,1], x2=x[,2], method="nonlin")
fit4 <- OutlierD(x1=x[,1], x2=x[,2], method="nonpar")

fit3$x[1:10,]

plot(fit3$x$A, fit3$x$M, pch=".", xlab="A", ylab="M")
i <- sort.list(fit3$x$A)
lines(fit3$x$A[i], fit3$x$Q3[i], lty=2); lines(fit3$x$A[i], fit3$x$Q1[i], lty=2)
lines(fit3$x$A[i], fit3$x$LB[i]); lines(fit3$x$A[i], fit3$x$UB[i])
title("Nonlinear")




