### Name: fdr.adjust
### Title: FDR adjustment procedures
### Aliases: fdr.adjust
### Keywords: methods

### ** Examples


 # Loading the library and the data
 library(LPE)
 data(Ley)
 
 dim(Ley)
 # Gives 12488*7 
 # First column is ID.

 Ley[,2:7] <- preprocess(Ley[,2:7],data.type="MAS5")

 # Subsetting the data
 subset.Ley <- Ley[1:1000,]
  
   
 # Finding the baseline distribution of condition 1 and 2.
 var.1 <- baseOlig.error(subset.Ley[,2:4], q=0.01)
 var.2 <- baseOlig.error(subset.Ley[,5:7], q=0.01)

 # Applying LPE
 lpe.result <- lpe(subset.Ley[,2:4],subset.Ley[,5:7], var.1, var.2,
                probe.set.name=subset.Ley[,1])

 final.result <- fdr.adjust(lpe.result, adjp="resamp", target.fdr=c(0.01,0.05), iterations=1)
 final.result
  



