### Name: zScores
### Title: Tools for Meta-analysis of gene expression data.
### Aliases: zScores multExpFDR zScoreFDR zScorePermuted
### Keywords: manip

### ** Examples

data(Nevins)
##Splitting 
thestatus  <- Nevins$ER.status
group1     <- which(thestatus=="pos")
group2     <- which(thestatus=="neg")
rrr        <- c(sample(group1, floor(length(group1)/2)),
                sample(group2,ceiling(length(group2)/2)))
Split1     <- Nevins[,rrr]
Split2     <- Nevins[,-rrr]

#obtain classes
Split1.ER <- as.numeric(Split1$ER.status)-1
Split2.ER <-as.numeric(Split2$ER.status)-1

esets     <- list(Split1,Split2)
classes   <- list(Split1.ER,Split2.ER)
theScores <- zScores(esets,classes,useREM=FALSE)
theScores[1:2,]



