segments.p              package:DNAcopy              R Documentation

_p-_v_a_l_u_e_s _f_o_r _t_h_e _c_h_a_n_g_e-_p_o_i_n_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     This program computes a p-value for the change-points found by the
      circular binary segmentation (CBS) algorithm.

_U_s_a_g_e:

       segments.p(x, ngrid=100, tol=1e-6)

_A_r_g_u_m_e_n_t_s:

       x: an object of class DNAcopy

   ngrid: number grid points for the integral

     tol: tolerance level for calculating nu

_D_e_t_a_i_l_s:

     The p-values are obtained by applying Siegmund's approximation for
     the maximal statistic from binary segmenting consecutive segments
     within a chromosome.  This p-value is only to give the relative
     importance of the change-points as the CBS is different from the
     algorithm used here.

_V_a_l_u_e:

     a data frame with eight columns.  The seventh column is the
     maximal statistic from binary segmentation and eighth is the
     p-values added to the six columns from the segment command.

_A_u_t_h_o_r(_s):

     Venkatraman E. Seshan olshena@mskcc.org

_E_x_a_m_p_l_e_s:

     # test code on an easy data set
     set.seed(25)
     genomdat <- rnorm(500, sd=0.1) +
     rep(c(-0.2,0.1,1,-0.5,0.2,-0.5,0.1,-0.2),c(137,87,17,49,29,52,87,42))
     plot(genomdat)
     chrom <- rep(1:2,c(290,210))
     maploc <- c(1:290,1:210)
     test1 <- segment(CNA(genomdat, chrom, maploc))
     segments.p(test1)

