### Name: subBString
### Title: Fast substring extraction
### Aliases: subBString subviews substr substr,BString-method
###   substr,BStringViews-method substring substring,BString-method
###   substring,BStringViews-method
### Keywords: methods manip

### ** Examples

  subBString("AxyxyxBC", 7)
  s <- BString("AxyxyxBC")
  subBString(s, 7)  # same as subBString("AxyxyxBC", 7)
  subBString(s, , 7)
  subBString(s, , 7, 3)
  identical(subBString(s), s) # TRUE

  v <- views(s, c(6, 4,-1, NA), c(7, 6, 1, 1))
  ## 2 equivalent ways of keeping the last letter of each view
  views(subject(v), end(v), end(v))
  subviews(v, end=width(v), width=1)

  ## 2 equivalent ways of making the views wider
  views(subject(v), start(v)-3, end(v)+3)
  subviews(v, -2, end=width(v)+3, check.limits=FALSE)



