### Name: scoring.matrices
### Title: Scoring matrices
### Aliases: scoring.matrices BLOSUM45 BLOSUM50 BLOSUM62 BLOSUM80 BLOSUM100
###   PAM30 PAM40 PAM70 PAM120 PAM250
### Keywords: utilities data datasets

### ** Examples

  ## Align 2 amino acid sequences with the BLOSUM62 matrix
  aa1 <- AAString("HXBLVYMGCHFDCXVBEHIKQZ")
  aa2 <- AAString("QRNYMYCFQCISGNEYKQN")
  needwunsQS(aa1, aa2, "BLOSUM62", gappen=3)

  ## See how the gap penalty influences the alignment
  needwunsQS(aa1, aa2, "BLOSUM62", gappen=8)

  ## See how the scoring matrix influences the alignment
  needwunsQS(aa1, aa2, "BLOSUM50", gappen=3)

  ## Compare our BLOSUM62 with BLOSUM62 from ftp://ftp.ncbi.nih.gov/blast/matrices/
  data(BLOSUM62)
  BLOSUM62["Q", "Z"]
  file <- "ftp://ftp.ncbi.nih.gov/blast/matrices/BLOSUM62"
  b62 <- as.matrix(read.table(file, check.names=FALSE))
  b62["Q", "Z"]



