### Name: findPalindromes
### Title: Searching a sequence for palindromes
### Aliases: findPalindromes findPalindromes,BString-method
###   findPalindromes,BStringViews-method palindromeArmLength
###   palindromeArmLength,BString-method
###   palindromeArmLength,BStringViews-method palindromeLeftArm
###   palindromeLeftArm,BString-method
###   palindromeLeftArm,BStringViews-method palindromeRightArm
###   palindromeRightArm,BString-method
###   palindromeRightArm,BStringViews-method
### Keywords: methods

### ** Examples

  ## Note that palindromes can be nested
  findPalindromes(DNAString("ACGTTNAACGT-ACGTTNAACGT"))

  ## A real use case
  library(BSgenome.Dmelanogaster.FlyBase.r51)
  chrX <- Dmelanogaster[["X"]]
  noN_chrX <- mask(chrX, "N")
  chrX_pals <- findPalindromes(noN_chrX, min.armlength=50, max.ngaps=20)
  palindromeArmLength(chrX_pals) # 251

  ## Of course, whitespaces matter
  palindromeArmLength(BString("was it a car or a cat I saw"))

  ## Note that the 2 arms of a strict palindrome (or antipalindrome) are equal
  ## to the full sequence.
  palindromeLeftArm(BString("Delia saw I was aileD"))
  palindromeLeftArm(DNAString("N-ACGTT-AACGT-N"))
  palindromeLeftArm(DNAString("N-AAA-N-N-TTT-N"), anti=FALSE)



