### Name: BStringViews-class
### Title: The BStringViews class
### Aliases: class:BStringViews BStringViews-class subject
###   subject,BStringViews-method length,BStringViews-method start
###   start,BStringViews-method first first,BStringViews-method end
###   end,BStringViews-method last last,BStringViews-method width
###   width,BStringViews-method nchar,BStringViews-method desc
###   desc,BStringViews-method desc<- desc<-,BStringViews-method
###   show,BStringViews-method [,BStringViews-method
###   [<-,BStringViews-method [[,BStringViews-method
###   [[<-,BStringViews-method ==,BStringViews,BStringViews-method
###   ==,BStringViews,BString-method ==,BStringViews,character-method
###   ==,BString,BStringViews-method ==,character,BStringViews-method
###   !=,BStringViews,BStringViews-method !=,BStringViews,BString-method
###   !=,BStringViews,character-method !=,BString,BStringViews-method
###   !=,character,BStringViews-method as.character,BStringViews-method
###   as.matrix,BStringViews-method as.list,BStringViews-method
###   toString,BStringViews-method
### Keywords: methods classes

### ** Examples

  s <- DNAString("-CTC-N")

  ## One standard way to create a BStringViews object is to use
  ## the "views" constructor:
  v4 <- views(s, 3:0, 5:8)
  v4
  subject(v4)
  length(v4)
  start(v4)
  end(v4)
  width(v4)

  ## Attach a comment to views #3 and #4:
  desc(v4)[3:4] <- "out of limits"
  desc(v4)

  ## A more programatical way to "tag" the "out of limits" views:
  desc(v4)[start(v4) < 1 | nchar(subject(v4)) < end(v4)] <- "out of limits"
  ## or just:
  desc(v4)[nchar(v4) < width(v4)] <- "out of limits"

  ## Make a new BStringViews object by selecting some views only:
  v4[4:2]               # 3 views
  v4[-1]                # 3 views
  v4[c(2,4)]            # 2 views
  v4[width(v4) >= 5]    # 3 views
  v4[is.na(desc(v4))]   # 2 views
  v4[!is.na(desc(v4))]  # 2 views
  v4[3]                 # 1 view
  v4[FALSE]             # 0 view

  ## Two equivalent ways to extract a view as a BString (or derived) object:
  s2a <- v4[[2]]
  s2b <- subBString(subject(v4), start(v4)[2], end(v4)[2])
  identical(s2a, s2b) # TRUE

  ## It is an error to try to extract an "out of limits" view:
  #v4[[3]] # Error!

  v12 <- views(DNAString("TAATAATG"), -2:9, 0:11)
  v12 == DNAString("TAA")
  v12[v12 == v12[4]]
  v12[v12 == v12[1]]
  v12[3] == views(RNAString("AU"), 0, 2)



