### Name: Bimap-keymethods
### Title: Methods for manipulating the keys of a Bimap object
### Aliases: Bimap-keymethods keys keys,Bimap-method length,Bimap-method
###   mappedkeys mappedkeys,Bimap-method mappedkeys,environment-method
###   mappedkeys,vector-method count.mappedkeys
###   count.mappedkeys,Bimap-method count.mappedkeys,ANY-method isNA
###   isNA,Bimap-method isNA,environment-method isNA,ANY-method Lkeys
###   Lkeys,FlatBimap-method Lkeys,AnnDbBimap-method Rkeys
###   Rkeys,FlatBimap-method Rkeys,AnnDbBimap-method
###   Rkeys,Go3AnnDbBimap-method Rkeys,AnnDbMap-method Llength
###   Llength,Bimap-method Llength,AnnDbBimap-method Rlength
###   Rlength,Bimap-method Rlength,AnnDbBimap-method
###   Rlength,Go3AnnDbBimap-method Rlength,AnnDbMap-method mappedLkeys
###   mappedLkeys,FlatBimap-method mappedLkeys,AnnDbBimap-method
###   mappedLkeys,Go3AnnDbBimap-method mappedLkeys,AgiAnnDbMap-method
###   mappedRkeys mappedRkeys,FlatBimap-method
###   mappedRkeys,AnnDbBimap-method mappedRkeys,Go3AnnDbBimap-method
###   mappedRkeys,AnnDbMap-method count.mappedLkeys
###   count.mappedLkeys,Bimap-method count.mappedLkeys,AnnDbBimap-method
###   count.mappedLkeys,Go3AnnDbBimap-method
###   count.mappedLkeys,AgiAnnDbMap-method count.mappedRkeys
###   count.mappedRkeys,Bimap-method count.mappedRkeys,AnnDbBimap-method
###   count.mappedRkeys,Go3AnnDbBimap-method
###   count.mappedRkeys,AnnDbMap-method keys<- keys<-,Bimap-method
###   [,Bimap-method Lkeys<- Lkeys<-,FlatBimap-method
###   Lkeys<-,AnnDbBimap-method Rkeys<- Rkeys<-,FlatBimap-method
###   Rkeys<-,AnnDbBimap-method subset subset,Bimap-method
###   subset,AnnDbBimap-method show,AnnDbTable-method
### Keywords: methods

### ** Examples

  library(hgu95av2.db)
  x <- hgu95av2GO
  x
  length(x)
  count.mappedkeys(x)
  x[1:3]
  links(x[1:3])

  ## Keep only mapped keys
  keys(x) <- mappedkeys(x)
  length(x)
  count.mappedkeys(x)
  x # now it is a submap

  ## The above can be achieved with
  x <- hgu95av2GO[mappedkeys(hgu95av2GO)]

  ## mappedkeys() and count.mappedkeys() also work with an environment
  ## or a list
  z <- list(k1=NA, k2=letters[1:4], k3="x")
  mappedkeys(z)
  count.mappedkeys(z)



