### Name: pkci2.flowcytest
### Title: Testing the difference of upper-tail distributions of two
###   samples
### Aliases: pkci2.flowcytest pkci2
### Keywords: univar htest

### ** Examples

if (require(rfcdmin)){
data.there<-is.element(c("st.1829", "unst.1829", "st.DRT", "unst.DRT"),objects())
if ( ( sum(data.there) != length(data.there) )){
## obtaining the FCS objects from VRC data
data(VRCmin)
}

 
## This only serves as an example.  Usually the FCS object is
## gated and then subset

## HIV negative individual 1829
  IFN.control<-unst.1829@data[1:2000,4]
  IFN.stimul<-st.1829@data[1:2000,4]

  output1.pkci2<-pkci2.flowcytest(IFN.control, IFN.stimul, crit=.9999)

## HIV positive individual DRT
  IFN.control2<-unst.DRT@data[1:2000,4]
  IFN.stimul2<-st.DRT@data[1:2000,4]
  output2.pkci2<-pkci2.flowcytest(IFN.control2, IFN.stimul2, crit=.9999)

## This is an artifical example, but one would expect the
## distributions of the stimulated and control samples
## to be the same in the HIV negative individual 1829
## and to be different in the HIV positive individual DRT
## The test in this example is a bit contrived but
## the bigger picture is achieved.
}




