### Name: heeboQualityPlots
### Title: Qualitative diagnostic plot for general hybridization, specific
###   to HEEBO set.
### Aliases: heeboQualityPlots
### Keywords: hplot

### ** Examples

if (interactive())
{
require(HEEBOdata)
datadir <- system.file("Heebo", package="HEEBOdata")
gal <- readGAL("hoc.gal", path=datadir)
RG <-
read.maimages(files=c("63421.gpr"), path=datadir, source="genepix.median",other.columns="Flags")
RG$genes <- gal
RG$printer <- getLayout(RG$genes)
RG$genes$Status <- controlStatus(HeeboSpotTypes,RG,verbose=TRUE)
rownames(RG$R) <- rownames(RG$G) <- RG$genes[,"ID"]
heeboQualityPlots(RG)
}



