### Name: identifyMajorPeaks
### Title: Identify peaks based on the ridges in 2-D CWT coefficient matrix
### Aliases: identifyMajorPeaks
### Keywords: methods

### ** Examples

        data(exampleMS)
        scales <- seq(1, 64, 3)
        wCoefs <- cwt(exampleMS, scales=scales, wavelet='mexh')
        
        localMax <- getLocalMaximumCWT(wCoefs)
        ridgeList <- getRidge(localMax)
        
        SNR.Th <- 3
        majorPeakInfo <- identifyMajorPeaks(ridgeList, wCoefs, SNR.Th=SNR.Th)
        ## Plot the identified peaks
        peakIndex <- majorPeakInfo$peakIndex
        plotPeak(exampleMS, peakIndex, main=paste('Identified peaks with SNR >', SNR.Th)) 
        



