### Name: relationshipAdditive
### Title: Additive relationship matrix and its inverse
### Aliases: relationshipAdditive inverseAdditive kinship
### Keywords: array misc

### ** Examples

  data(Mrode2.1)
  Mrode2.1$dtB <- as.Date(Mrode2.1$dtB)
  x2.1 <- Pedigree(x=Mrode2.1, subject="sub", ascendant=c("fat", "mot"),
                   ascendantSex=c("M", "F"), family="fam", sex="sex",
                   generation="gen", dtBirth="dtB")

  (A <- relationshipAdditive(x2.1))
  fractions(A)
  solve(A)
  inverseAdditive(x2.1)
  relationshipAdditive(x2.1[3:6, ])

  ## Compare the speed
  ped <- generatePedigree(nId=10, nGeneration=3, nFather=1, nMother=2)
  system.time(solve(relationshipAdditive(ped)))
  system.time(inverseAdditive(ped))



