### Name: cbind
### Title: Combine RGList_CALIB, SpikeList or ParameterList objects
### Aliases: cbind.RGList_CALIB cbind.SpikeList cbind.ParameterList
###   rbind.RGList_CALIB rbind.SpikeList
### Keywords: manip

### ** Examples


R1 <- G1 <- matrix(1:8,4,2)
rownames(R1) <- rownames(G1) <- c("g1","g2","g3","g4")
colnames(R1) <- colnames(G1) <- c("a1","a2")
RG1 <- new("RGList_CALIB",list(R=R1,G=G1))

R2 <- G2 <- matrix(9:16,4,2)
rownames(R2) <- rownames(G2) <- c("g1","g2","g3","g4")
colnames(R2) <- colnames(G2) <- c("a3","a4")
RG2 <- new("RGList_CALIB",list(R=R2,G=G2))

RG <- cbind(RG1,RG2)




