### Name: SAM-class
### Title: Class SAM
### Aliases: SAM-class SAM identify,SAM-method plot,SAM-method
###   print,SAM-method show,SAM-method summary,SAM-method
### Keywords: classes

### ** Examples
## Not run: 
##D   # Load the package multtest and the data of Golub et al. (1999)
##D   # contained in multtest.
##D   library(multtest)
##D   data(golub)
##D   
##D   # Perform a SAM analysis for the two class unpaired case assuming
##D   # unequal variances.
##D   sam.out<-sam(golub,golub.cl,B=100,rand=123)
##D   sam.out
##D   
##D   # Alternative ways to show the output of sam.
##D   show(sam.out)
##D   print(sam.out)
##D   
##D   # Obtain a little bit more information.
##D   summary(sam.out)
##D   
##D   # Print the results of the SAM analysis for other values of Delta.
##D   print(sam.out,seq(.2,2,.2))
##D   
##D   # Again, the same with additional information.
##D   summary(sam.out,seq(.2,2,.2))
##D     
##D   # Obtain the Delta plots for the default set of Deltas.
##D   plot(sam.out)
##D   
##D   # Generate the Delta plots for Delta = 0.2, 0.4, 0.6, ..., 2.
##D   plot(sam.out,seq(0.2,0.4,2))
##D   
##D   # Obtain the SAM plot for Delta = 2.
##D   plot(sam.out,2)
##D   
##D   # Get information about the genes called significant using 
##D   # Delta = 3 (since neither the gene names nor the chip type
##D   # has been specified ll is set to FALSE to avoid a warning).
##D   sam.sum3<-summary(sam.out,3,ll=FALSE)
##D   sam.sum3
##D   
##D   # Obtain the rows of the Golub et al. (1999) data set containing
##D   # the genes called differentially expressed
##D   sam.sum3@row.sig.genes
##D   
##D   # and their names
##D   golub.gnames[sam.sum3@row.sig.genes,3] 
##D 
##D   # The matrix containing the d-values, q-values etc. of the
##D   # differentially expressed genes can be obtained by
##D   sam.sum3@mat.sig
## End(Not run)


