### Name: fcs.type
### Title: Objects providing parameters for the raw FCS file types
### Aliases: fcs.type FCS.type fcs.type.LYSYS
###   fcs.type.cellquest.3.1.FACS.Vantage fcs.type.cellquest.3.1.FACScan
###   fcs.type.cellquest.3.3 fcs.type.default fcs.type.LSR256
###   fcs.type.FACStar256 fcs.type.facscan256 fcs.type.DiVa1024
###   fcs.type.FACSCalibur1024 fcs.type.LSR1024 fcs.type.facscan1024
### Keywords: environment

### ** Examples


  if (require(rfcdmin)) {
    ## obtaining the location of the fcs files in the data
    get.path<-function(filename) {
      datadir<-system.file("fcs", package="rfcdmin")
      return(paste(datadir, filename, sep="/"))
    }


    FF256 <-read.FCS(get.path("facscan256.fcs"),
                              fcs.type=fcs.type.facscan256)
  }




