get.p                package:rflowcyt                R Documentation

_T_e_s_t _i_f _t_h_e _k_e_r_n_e_l _d_e_n_s_i_t_y _e_s_t_i_m_a_t_e _g_i_v_e_n _b_y _x _a_n_d _h_0 _h_a_s _a_t _m_o_s_t _m _m_o_d_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     This function returns the p-value of rejecting the null hypothesis
     that the kernel density estimate given by x and h0 has at most m
     modes.

_U_s_a_g_e:

     get.p(x,h0,m=1,num.sim=200)

_A_r_g_u_m_e_n_t_s:

       x: the data vector 

      h0: the bandwidth for the gaussian kernel density estimate for
          the standardized data

       m: the number iof modes we are trying to reject is the maximum 

 num.sim: the number of bootstrap simulations to determine this p-value 

_V_a_l_u_e:

     returns the p-value of the test

_A_u_t_h_o_r(_s):

     Kevin Rader

_R_e_f_e_r_e_n_c_e_s:

     B.W. Silverman (1981),Using Kernel Density Estimates to
     Investigate Multimodatlity. J.R. Statist. Soc. B,43,1,97-99.

_S_e_e _A_l_s_o:

     'get.h', 'emp.f', 'get.num.modes'

_E_x_a_m_p_l_e_s:

      set.seed(12345)
      x1<-matrix(rnorm(50),ncol=1)
      x2<-matrix(c(rnorm(25,mean=-2),rnorm(25,mean=2)),ncol=1)
      h1<-get.h(x1,m=1,prec=0.001)
      h2<-get.h(x2,m=1,prec=0.001)
      p1<-get.p(x1,h1,1,100)
      p2<-get.p(x2,h2,1,100)
      c(p1,p2)

