### Name: matest
### Title: Statistical test for Microarray experiment
### Aliases: matest
### Keywords: models

### ** Examples

# load in Paigen's data
data(paigen)
# make data object with rep 2
paigen <- createData(paigen.raw, 2)
# Note that the data is normalized so normalization is skipped

##################################
# fixed model test
##################################
# make an additive model
model.add.fix <- makeModel(data=paigen, formula=~Dye+Array+Strain+Diet)
# test strain effect
## Not run: test.Strain.fix <- matest(paigen, model.add.fix, term="Strain", n.perm=100)
# volcano plot
## Not run: idx <- volcano(test.Strain.fix)

# test pairwise comparisions for Strain, using a MPI cluster with 8 nodes
## Not run: C <- matrix(c(1,-1,0,1,0,-1, 0,1,-1), nrow=3, byrow=TRUE)
## Not run: 
##D ttest.strain.fix <- matest(paigen, model.add.fix,
##D          term="Strain", Contrast=C, n.perm=100, nnodes=8)
## End(Not run)
## Not run: volcano(ttest.strain.fix)

# a user specified F-test on Strain
# note that the F- and P-values generated in this test is exactly the
# same as the above F-test. But the volcano plot looks a little
# different because the X-axis values are different
## Not run: 
##D C <- matrix(c(1,-1/2,-1/2,1,0,-1), nrow=2, byrow=TRUE)
##D test.Strain.fix <- matest(paigen, model.add.fix, term="Strain",
##D Contrast=C, test.type="ftest", n.perm=100)
## End(Not run)

##################################
# mixed model test
##################################
# mixed model permutation test is very slow
# I will skip the example for that
# the syntax of the function will be the same
# except the input model object is for mixed effects model



