### Name: edgeMatrix
### Title: Compute an Edge Matrix or weight vector for a Graph
### Aliases: edgeMatrix eWV pathWeights edgeMatrix,graphNEL-method
###   edgeMatrix,clusterGraph-method edgeMatrix,distGraph-method
### Keywords: manip

### ** Examples

  set.seed(123)
  g1 <- randomGraph(letters[1:10], 1:4, p=.3)
  edgeMatrix(g1)
  g2 <- new("clusterGraph", clusters=list(a=c(1,2,3), b=c(4,5,6)))
  em2 <- edgeMatrix(g2)
  eWV(g1, edgeMatrix(g1))
  eWV(g1, edgeMatrix(g1), useNNames=TRUE)
  pathWeights(g1, c("b", "a", "i"))



