/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.boss;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.systemsbiology.gaggle.boss.Boss;
import org.systemsbiology.gaggle.boss.BossConfig;
import org.systemsbiology.gaggle.boss.GaggleBossTableModel;
import org.systemsbiology.gaggle.boss.NameUniquifier;
import org.systemsbiology.gaggle.boss.TileCalculator;
import org.systemsbiology.gaggle.boss.plugins.GaggleBossPlugin;
import org.systemsbiology.gaggle.experiment.datamatrix.DataMatrix;
import org.systemsbiology.gaggle.geese.DeafGoose;
import org.systemsbiology.gaggle.geese.Goose;
import org.systemsbiology.gaggle.network.Network;
import org.systemsbiology.gaggle.util.MiscUtil;
import org.systemsbiology.gaggle.util.NewNameHelper;

public final class GuiBoss
extends UnicastRemoteObject
implements Boss,
WindowStateListener,
Serializable {
    protected JFrame frame;
    protected JTable gooseTable;
    protected JScrollPane scrollPane;
    protected JTextField searchBox;
    protected GaggleBossTableModel gooseTableModel;
    protected String serviceName = "gaggle";
    protected NewNameHelper nameHelper;
    protected HashMap gooseMap;
    protected HashMap gooseListeningMap;
    transient NameUniquifier nameUniquifier;
    ArrayList deafGeese = new ArrayList();
    ArrayList plugins = new ArrayList();
    JPanel outerPanel;
    JTabbedPane tabbedPanel;
    JButton frameSizeToggleButton;
    boolean bodyVisible = true;
    BossConfig config;

    public GuiBoss() throws RemoteException {
        this(new String[0]);
    }

    public GuiBoss(String[] stringArray) throws RemoteException {
        this.config = new BossConfig(stringArray);
        String string = this.config.getNameHelperUri();
        if (string != null && string.length() > 0) {
            try {
                this.nameHelper = new NewNameHelper(string);
            }
            catch (Exception exception) {
                String string2 = "Error reading name helper file from " + string + "\n" + exception.getMessage();
                JOptionPane.showMessageDialog(this.frame, string2);
            }
        }
        this.gooseMap = new HashMap();
        this.gooseListeningMap = new HashMap();
        this.nameUniquifier = new NameUniquifier();
        this.frame = new JFrame(this.createFrameTitle());
        this.frame.addWindowStateListener(this);
        try {
            LocateRegistry.createRegistry(1099);
            Naming.rebind(this.serviceName, this);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Gaggle Port already in use.  Exiting....");
            System.exit(0);
        }
        this.frame.setDefaultCloseOperation(3);
        this.frame.addWindowStateListener(this);
        this.frame.getContentPane().add(this.createGui());
        this.frame.pack();
        this.frame.setVisible(true);
        this.frame.toFront();
    }

    public BossConfig getConfig() {
        return this.config;
    }

    public NewNameHelper getNameHelper() {
        return this.nameHelper;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void windowStateChanged(WindowEvent windowEvent) {
        System.out.println("\n-------- GuiBoss window event: " + windowEvent.paramString());
        System.out.println("old state: " + windowEvent.getOldState() + "  new state: " + windowEvent.getNewState());
    }

    public String renameGoose(String string, String string2) {
        String string3 = this.nameUniquifier.makeUnique(string2);
        if (this.gooseMap.containsKey(string)) {
            Goose goose = (Goose)this.gooseMap.get(string);
            this.gooseMap.remove(string);
            this.gooseMap.put(string3, goose);
            try {
                goose.setName(string3);
                return string3;
            }
            catch (RemoteException remoteException) {
                String string4 = "Failed to contact goose to rename: " + string + " -> " + string3;
                JOptionPane.showMessageDialog(this.frame, string4);
            }
        }
        return null;
    }

    protected String createFrameTitle() {
        String string = "$Revision: 872 $";
        String string2 = "Revision: ";
        int n = string.indexOf(string2);
        int n2 = string.indexOf(" $", n += string2.length());
        String string3 = string.substring(n, n2);
        return "Gaggle Boss v." + string3;
    }

    public String register(Goose goose) throws RemoteException {
        String string = this.nameUniquifier.makeUnique(goose.getName());
        goose.setName(string);
        this.addNewGoose(string, goose);
        this.refresh();
        return string;
    }

    public String register(DeafGoose deafGoose) throws RemoteException {
        this.deafGeese.add(deafGoose);
        return "";
    }

    public void remove(String string) throws RemoteException {
        if (this.gooseMap.containsKey(string)) {
            this.gooseMap.remove(string);
        }
        if (this.gooseListeningMap.containsKey(string)) {
            this.gooseListeningMap.remove(string);
        }
    }

    public Goose[] getGeese() {
        return this.gooseMap.values().toArray(new Goose[0]);
    }

    public String[] getSelectedGooseNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = this.gooseTable.getSelectedRows();
        String[] stringArray = this.gooseTableModel.getAppNames();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(stringArray[nArray[i]]);
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getUnselectedGooseNames() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int[] nArray = this.gooseTable.getSelectedRows();
        Object[] objectArray = this.getSelectedGooseNames();
        Object[] objectArray2 = this.getGooseNames();
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        for (int i = 0; i < objectArray2.length; ++i) {
            if (Arrays.binarySearch(objectArray, objectArray2[i]) >= 0) continue;
            arrayList.add(objectArray2[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    public Goose getGoose(String string) {
        return (Goose)this.gooseMap.get(string);
    }

    public String[] getGooseNames() {
        return this.gooseMap.keySet().toArray(new String[0]);
    }

    public HashMap getGooseMap() {
        return this.gooseMap;
    }

    protected void broadcastToPlugins(String[] stringArray) {
        for (int i = 0; i < this.plugins.size(); ++i) {
            GaggleBossPlugin gaggleBossPlugin = (GaggleBossPlugin)this.plugins.get(i);
            gaggleBossPlugin.select(stringArray);
        }
    }

    public void broadcast(String string, String string2, String string3, String[] stringArray) throws RemoteException {
        long l = System.currentTimeMillis();
        this.broadcastToPlugins(stringArray);
        String[] stringArray2 = string2 == null || string2.equalsIgnoreCase("boss") || string2.equalsIgnoreCase("all") ? this.getListeningGeese() : new String[]{string2};
        for (int i = 0; i < stringArray2.length; ++i) {
            Goose goose;
            String string4 = stringArray2[i];
            if (string4.equals(string) || (goose = this.getGoose(string4)) == null) continue;
            try {
                goose.handleNameList(string3, stringArray);
                continue;
            }
            catch (Exception exception) {
                System.err.println("error in select request to " + goose.getName() + ": " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        this.refresh(true);
        long l2 = System.currentTimeMillis() - l;
    }

    public void broadcast(String string, String string2, DataMatrix dataMatrix) throws RemoteException {
        long l = System.currentTimeMillis();
        this.broadcastToPlugins(dataMatrix.getRowTitles());
        String[] stringArray = string2 == null || string2.equalsIgnoreCase("boss") || string2.equalsIgnoreCase("all") ? this.getListeningGeese() : new String[]{string2};
        for (int i = 0; i < stringArray.length; ++i) {
            Goose goose;
            String string3 = stringArray[i];
            if (string3.equals(string) || (goose = this.getGoose(string3)) == null) continue;
            try {
                goose.handleMatrix(dataMatrix);
                continue;
            }
            catch (Exception exception) {
                System.err.println("error in handleMatrix request to " + string3 + ": " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        this.refresh(true);
        long l2 = System.currentTimeMillis() - l;
    }

    public void broadcast(String string, String string2, String string3, String string4, HashMap hashMap) {
        long l = System.currentTimeMillis();
        this.refresh();
        String[] stringArray = string2 == null || string2.equalsIgnoreCase("boss") || string2.equalsIgnoreCase("all") ? this.getListeningGeese() : new String[]{string2};
        for (int i = 0; i < stringArray.length; ++i) {
            Goose goose;
            String string5 = stringArray[i];
            if (string5.equals(string) || (goose = this.getGoose(string5)) == null) continue;
            try {
                System.out.println("broadcast hashmap to " + string5);
                goose.handleMap(string3, string4, hashMap);
                continue;
            }
            catch (Exception exception) {
                System.err.println("error in broadcast (HahsMap) to " + string5 + ": " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public void broadcast(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2) {
        long l = System.currentTimeMillis();
        this.broadcastToPlugins(stringArray);
        String[] stringArray3 = string2 == null || string2.equalsIgnoreCase("boss") || string2.equalsIgnoreCase("all") ? this.getListeningGeese() : new String[]{string2};
        for (int i = 0; i < stringArray3.length; ++i) {
            Goose goose;
            String string5 = stringArray3[i];
            if (string5.equals(string) || !this.isListening(string5) || (goose = this.getGoose(string5)) == null) continue;
            try {
                goose.handleCluster(string3, string4, stringArray, stringArray2);
                continue;
            }
            catch (Exception exception) {
                System.err.println("error in broadcastCluster () to " + string5 + ": " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        long l2 = System.currentTimeMillis() - l;
        this.refresh();
        System.out.println("GuiBoss.broadcastCluster  " + string4 + ", " + "rows: " + stringArray.length + "columns: " + stringArray2.length + ": " + l2 + " msecs");
    }

    public void broadcast(String string, String string2, String string3, Network network) {
        String[] stringArray = string2 == null || string2.equalsIgnoreCase("boss") || string2.equalsIgnoreCase("all") ? this.getListeningGeese() : new String[]{string2};
        for (int i = 0; i < stringArray.length; ++i) {
            Goose goose;
            String string4 = stringArray[i];
            if (string4.equals(string) || (goose = this.getGoose(string4)) == null) continue;
            try {
                goose.handleNetwork(string3, network);
                continue;
            }
            catch (Exception exception) {
                System.err.println("error in broadcastNetwork () to " + string4 + ": " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        this.refresh();
    }

    public void cleanUpOnExit(String string) throws RemoteException {
    }

    public void hide(String string) throws RemoteException {
        String[] stringArray;
        if (string == null) {
            stringArray = this.getListeningGeese();
        } else {
            if (string.equalsIgnoreCase("boss")) {
                this.frame.setVisible(false);
                return;
            }
            stringArray = new String[]{string};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Goose goose = this.getGoose(stringArray[i]);
            if (goose == null) continue;
            try {
                goose.doHide();
                continue;
            }
            catch (Exception exception) {
                System.err.println("error in hide request to " + string + ": " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public void show(String string) throws RemoteException {
        if (string.equalsIgnoreCase("boss")) {
            if (this.getFrame().getExtendedState() != 0) {
                this.getFrame().setExtendedState(0);
            }
            this.getFrame().setAlwaysOnTop(true);
            MiscUtil.setJFrameAlwaysOnTop(this.getFrame(), true);
            this.getFrame().setVisible(true);
            this.getFrame().setAlwaysOnTop(false);
            MiscUtil.setJFrameAlwaysOnTop(this.getFrame(), false);
            return;
        }
        Goose goose = this.getGoose(string);
        if (goose == null) {
            return;
        }
        try {
            goose.doShow();
        }
        catch (Exception exception) {
            System.err.println("error in show request to " + string + ": " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void askForShow(String string) throws RemoteException {
        this.getFrame().toBack();
        this.getFrame().toFront();
        this.getFrame().setVisible(true);
    }

    public void clearSelections(String string) throws RemoteException {
        Goose goose = this.getGoose(string);
        if (goose == null) {
            return;
        }
        try {
            goose.clearSelections();
        }
        catch (Exception exception) {
            System.err.println("error in clearSelections request to " + string + ": " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void setGeometry(String string, int n, int n2, int n3, int n4) throws RemoteException {
        Goose goose = this.getGoose(string);
        if (goose == null) {
            return;
        }
        try {
            goose.setGeometry(n, n2, n3, n4);
        }
        catch (Exception exception) {
            System.err.println("error in setGeometry request to " + string);
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void terminate(String string) throws RemoteException {
        Goose goose = this.getGoose(string);
        if (goose == null) {
            return;
        }
        try {
            goose.doExit();
        }
        catch (UnmarshalException unmarshalException) {
        }
        catch (Exception exception) {
            System.err.println("error in terminate request to " + string + ": " + exception.getMessage());
        }
    }

    public void toggleVisibility() {
        this.bodyVisible = !this.bodyVisible;
        String string = "Shrink";
        if (!this.bodyVisible) {
            string = "Boss";
        }
        this.frameSizeToggleButton.setText(string);
        this.tabbedPanel.setVisible(this.bodyVisible);
        this.frame.pack();
    }

    protected JPanel createGui() {
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.frameSizeToggleButton = new JButton("Shrink");
        this.frameSizeToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiBoss.this.toggleVisibility();
            }
        });
        jToolBar.add(this.frameSizeToggleButton);
        this.outerPanel.add((Component)jToolBar, "North");
        JButton jButton = new JButton("About");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html><center>");
                stringBuffer.append("<h3>");
                stringBuffer.append("The Gaggle is developed by the Baliga Laboratory<br>");
                stringBuffer.append("at the Institute for Systems Biology.<br>");
                stringBuffer.append("</h3>");
                stringBuffer.append("<font color='blue'>");
                stringBuffer.append("http://www.systemsbiology.org<br>");
                stringBuffer.append("</font>");
                stringBuffer.append("<br>");
                stringBuffer.append("Software engineer:  Paul Shannon<br>");
                stringBuffer.append("Principal Investigator: Nitin S. Baliga<br>");
                stringBuffer.append("<br>");
                stringBuffer.append("Supported by research grants from NSF, DoE and DoD<br>");
                stringBuffer.append("<br>");
                stringBuffer.append("For more information visit the Baliga Laboratory: <br>");
                stringBuffer.append("<font color='blue' size='-1'>");
                stringBuffer.append("http://www.systembiology.org/Scientists_and_Research/Faculty_Groups/Baliga_Group");
                stringBuffer.append("</font>");
                stringBuffer.append("</center></html>");
                String string = stringBuffer.toString();
                String string2 = "About the Gaggle";
                int n = 1;
                Icon icon = null;
                JOptionPane.showMessageDialog(GuiBoss.this.frame, string, string2, n, icon);
            }
        });
        jToolBar.add(jButton);
        this.outerPanel.add((Component)jToolBar, "North");
        this.tabbedPanel = new JTabbedPane();
        this.outerPanel.add((Component)this.tabbedPanel, "Center");
        this.tabbedPanel.add((Component)this.createGaggleControlPanel(), "Gaggle");
        String[] stringArray = this.config.getPluginNames();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("about to load boss plugin: " + stringArray[i]);
            GaggleBossPlugin gaggleBossPlugin = this.loadPlugin(stringArray[i], this);
            if (gaggleBossPlugin == null) {
                String string = "Could not locate plugin '" + stringArray[i] + "'";
                JOptionPane.showMessageDialog(this.frame, string);
                continue;
            }
            this.plugins.add(gaggleBossPlugin);
            this.tabbedPanel.add((Component)gaggleBossPlugin, gaggleBossPlugin.getName());
        }
        return this.outerPanel;
    }

    protected JPanel createGaggleControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        int n = 20;
        int n2 = 10;
        int n3 = 20;
        jPanel.setBorder(BorderFactory.createEmptyBorder(n, n3, n2, n3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.createButtonsInPanel(), "Center");
        jPanel2.add((Component)jPanel3, "South");
        this.gooseTableModel = new GaggleBossTableModel(this);
        this.gooseTable = new JTable(this.gooseTableModel);
        this.gooseTable.setSelectionMode(2);
        this.gooseTable.setShowGrid(true);
        this.gooseTable.setGridColor(Color.gray);
        this.gooseTable.setDefaultRenderer(JButton.class, new ButtonCellRenderer(this.gooseTable.getDefaultRenderer(JButton.class)));
        this.setTableColumnWidths();
        this.gooseTable.setPreferredScrollableViewportSize(new Dimension(400, 200));
        this.gooseTable.addMouseListener(new GaggleMouseListener(this.gooseTable));
        this.scrollPane = new JScrollPane(this.gooseTable);
        jPanel.add((Component)this.scrollPane, "Center");
        return jPanel2;
    }

    protected JPanel createButtonsInPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        JButton jButton = new JButton("Show");
        JButton jButton2 = new JButton("Show Others");
        JButton jButton3 = new JButton("Hide");
        JButton jButton4 = new JButton("Hide Others");
        JButton jButton5 = new JButton("Select All");
        JButton jButton6 = new JButton("Refresh");
        JButton jButton7 = new JButton("Clear Selections");
        JButton jButton8 = new JButton("Listen All");
        JButton jButton9 = new JButton("Listen None");
        JButton jButton10 = new JButton("Terminate");
        JButton jButton11 = new JButton("Quit");
        jButton.addActionListener(new ShowAction());
        jButton2.addActionListener(new ShowOthersAction());
        jButton3.addActionListener(new HideAction());
        jButton4.addActionListener(new HideOthersAction());
        jButton5.addActionListener(new SelectAllAction());
        jButton6.addActionListener(new RefreshAction());
        jButton8.addActionListener(new ListenAllAction());
        jButton9.addActionListener(new ListenNoneAction());
        jButton10.addActionListener(new TerminateAction());
        jButton11.addActionListener(new QuitAction());
        jButton7.addActionListener(new ClearSelectionsAction());
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        jPanel3.add(jButton4);
        jPanel3.add(jButton7);
        jPanel4.add(jButton5);
        jPanel4.add(jButton6);
        jPanel4.add(jButton8);
        jPanel4.add(jButton9);
        jPanel4.add(jButton10);
        jPanel5.add(jButton11);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    protected void setTableColumnWidths() {
    }

    protected String[] getListeningGeese() {
        String[] stringArray = this.getGooseNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.listening(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    protected boolean listening(String string) {
        return this.gooseTableModel.isListening(string);
    }

    protected void setSelectionCount(String string, int n) {
        this.gooseTableModel.setSelectionCount(string, n);
    }

    protected void removeGooseFromGaggle(String string) {
        this.gooseTableModel.removeGoose(string);
        try {
            this.remove(string);
            this.setTableColumnWidths();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean bl) {
        HashMap hashMap = this.getGooseMap();
        String[] stringArray = this.getGooseNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Goose goose = (Goose)hashMap.get(string);
            try {
                int n = goose.getSelectionCount();
                this.setSelectionCount(string, n);
                continue;
            }
            catch (RemoteException remoteException) {
                this.removeGooseFromGaggle(string);
            }
        }
        if (bl) {
            this.setTableColumnWidths();
        }
    }

    public void askGooseToBroadcast(String string) {
        Goose goose = this.getGoose(string);
        if (goose == null) {
            return;
        }
        try {
            goose.doBroadcastList();
        }
        catch (RemoteException remoteException) {
            System.err.println("---- GuiBoss.askGooseToBroadcast exception");
            System.err.println("error when asking goose (" + string + ") to broadcast");
            System.err.println(remoteException.getMessage());
        }
    }

    public String[] getSelection(String string) {
        Goose goose = this.getGoose(string);
        if (goose == null) {
            return new String[0];
        }
        String[] stringArray = new String[]{};
        try {
            stringArray = goose.getSelection();
        }
        catch (RemoteException remoteException) {
            System.err.println("---- GuiBoss.getSelection exception");
            System.err.println("error when asking goose (" + string + ") for its selection");
            System.err.println(remoteException.getMessage());
        }
        return stringArray;
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    private void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.frame.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.frame.getWidth();
        int n4 = this.frame.getHeight();
        this.frame.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    public void addNewGoose(String string, Goose goose) {
        this.gooseMap.put(string, goose);
        this.gooseTableModel.addClient(string);
        this.setTableColumnWidths();
    }

    public boolean isListening(String string) {
        return this.gooseTableModel.isListening(string);
    }

    public GaggleBossPlugin loadPlugin(String string, GuiBoss guiBoss) {
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{guiBoss.getClass()};
            Object[] objectArray = new Object[]{guiBoss};
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object obj = constructor.newInstance(objectArray);
            return (GaggleBossPlugin)obj;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
            return null;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        GuiBoss guiBoss = new GuiBoss(stringArray);
    }

    class ButtonCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer defaultRenderer;

        public ButtonCellRenderer(TableCellRenderer tableCellRenderer) {
            this.defaultRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Component) {
                return (Component)object;
            }
            return this.defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class GaggleMouseListener
    implements MouseListener {
        private JTable table;

        public GaggleMouseListener(JTable jTable) {
            this.table = jTable;
        }

        private void forwardEventToButton(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = mouseEvent.getY() / this.table.getRowHeight();
            if (n2 >= this.table.getRowCount() || n2 < 0 || n >= this.table.getColumnCount() || n < 0) {
                return;
            }
            Object object = this.table.getValueAt(n2, n);
            if (!(object instanceof JButton)) {
                return;
            }
            JButton jButton = (JButton)object;
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.table, mouseEvent, jButton);
            jButton.doClick();
            this.table.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.forwardEventToButton(mouseEvent);
        }
    }

    class QuitAction
    extends AbstractAction {
        QuitAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(GuiBoss.this.frame, "Really Quit?", "Exit the Gaggle Boss?", 0);
            if (n == 1) {
                return;
            }
            try {
                Naming.unbind(GuiBoss.this.serviceName);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
    }

    class TerminateAction
    extends AbstractAction {
        TerminateAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GuiBoss.this.refresh();
            String[] stringArray = GuiBoss.this.getSelectedGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    GuiBoss.this.terminate(stringArray[i]);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
            GuiBoss.this.refresh(true);
        }
    }

    class StaggerAction
    extends AbstractAction {
        StaggerAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("StaggerAction");
        }
    }

    class TileAction
    extends AbstractAction {
        TileAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = GuiBoss.this.gooseTable.getSelectedRows();
            String[] stringArray = GuiBoss.this.gooseTableModel.getAppNames();
            int n = nArray.length;
            GraphicsConfiguration graphicsConfiguration = GuiBoss.this.frame.getGraphicsConfiguration();
            int n2 = (int)graphicsConfiguration.getBounds().getHeight();
            int n3 = (int)graphicsConfiguration.getBounds().getWidth();
            int n4 = n + 1;
            TileCalculator tileCalculator = new TileCalculator(n3, n2, n4);
            int[] nArray2 = tileCalculator.getGeometry(0);
            int n5 = nArray2[0];
            int n6 = nArray2[1];
            int n7 = (int)GuiBoss.this.frame.getPreferredSize().getWidth();
            int n8 = (int)GuiBoss.this.frame.getPreferredSize().getHeight();
            int n9 = nArray2[2];
            int n10 = nArray2[3];
            if (n9 > n7) {
                n9 = n7;
            }
            if (n10 > n8) {
                n10 = n8;
            }
            GuiBoss.this.frame.setSize(n9, n10 - tileCalculator.getTitleBarHeight());
            GuiBoss.this.frame.setLocation(n5, n6);
            for (int i = 0; i < n; ++i) {
                String string = stringArray[nArray[i]];
                nArray2 = tileCalculator.getGeometry(i + 1);
                n5 = nArray2[0];
                n6 = nArray2[1];
                n9 = nArray2[2];
                n10 = nArray2[3] - tileCalculator.getTitleBarHeight();
                try {
                    GuiBoss.this.setGeometry(string, n5, n6, n9, n10);
                    GuiBoss.this.show(string);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    class ListenNoneAction
    extends AbstractAction {
        ListenNoneAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                GuiBoss.this.gooseTableModel.setListeningState(string, false);
            }
        }
    }

    class ListenAllAction
    extends AbstractAction {
        ListenAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                GuiBoss.this.gooseTableModel.setListeningState(string, true);
            }
        }
    }

    class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GuiBoss.this.refresh(true);
        }
    }

    class ClearSelectionsAction
    extends AbstractAction {
        ClearSelectionsAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getSelectedGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    GuiBoss.this.clearSelections(stringArray[i]);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
            GuiBoss.this.refresh(true);
        }
    }

    class HideOthersAction
    extends AbstractAction {
        HideOthersAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getUnselectedGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    GuiBoss.this.hide(stringArray[i]);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    class HideAction
    extends AbstractAction {
        HideAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getSelectedGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    GuiBoss.this.hide(stringArray[i]);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    class ShowOthersAction
    extends AbstractAction {
        ShowOthersAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getUnselectedGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    GuiBoss.this.show(stringArray[i]);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    class ShowAction
    extends AbstractAction {
        ShowAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getSelectedGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    GuiBoss.this.show(stringArray[i]);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GuiBoss.this.gooseTable.selectAll();
        }
    }
}

