### Name: or.segSet
### Title: Union of 2 segments sets
### Aliases: or.segSet |.segSet unionSeg or or.default
### Keywords: utilities

### ** Examples

from <- c(100,75, 1 ,25,150)
to   <- c(110,120,30,50,170)
or(as.segSet(data.frame(from,to)))
## return:
## from, to
## 1, 50
## 75,120
## 150,170

or.segSet(data.frame(from,to),simplify=FALSE)


## Tip to compute intergenic region
## (imagine: from = genes$start, to=genes$stop

x <- or.segSet(data.frame(from,to))
start <- x[,1]
stop <- x[,2]
n <- length(start)
intergenes <-cbind(stop[1:n-1],start[2:n])
intergenes




