### Name: comp.t
### Title: Computing One and Two Sample t-statistic for Differential
###   Expression
### Aliases: comp.t
### Keywords: univar

### ** Examples

X <- matrix(rnorm(1000,0,0.5), nc=10)
L <- rep(0:1,c(5,5))

# genes 1-10 are differentially expressed
X[1:10,6:10]<-X[1:10,6:10]+1

# two sample test, unequal variance
t.fun <- comp.t(L)
t.X <- t.fun(X)

# two sample test, equal variance
t.fun <- comp.t(L, var.equal=TRUE)
t.X <- t.fun(X)



