### Name: BSgenome-class
### Title: The BSgenome class
### Aliases: class:BSgenome BSgenome-class initialize,BSgenome-method
###   names,BSgenome-method show,BSgenome-method length,BSgenome-method
###   [[,BSgenome-method [[<-,BSgenome-method $,BSgenome-method unload
###   unload,BSgenome-method
### Keywords: methods classes

### ** Examples

  library(BSgenome.Celegans.UCSC.ce2)
  length(Celegans)
  Celegans

  ## Access chromosome V (BStringViews object) with
  Celegans[["chrV"]]
  ## or with
  Celegans$chrV

  ## Note that the chromosome V data are not loaded into memory until the
  ## first time you try to access them (what gets loaded is the serialized
  ## BStringViews instance stored in the "chrV.rda" file)
  ## To unload chromosome V (if you need to free some memory)
  unload(Celegans, "chrV")

  ## Note that assignment of BStringViews objects does NOT copy the data
  c <- Celegans[["chrV"]]

  ## But then, clean unloading is a bit more complicated
  unload(Celegans, "chrV")
  remove(c)
  ## More generally, you need to keep track of all BStringViews objects
  ## referencing the same data if you want to be able to unload these data
  ## from memory



