### Name: sam
### Title: Significance Analysis of Microarray
### Aliases: sam
### Keywords: htest

### ** Examples
## Not run: 
##D   # Load the package multtest and the data of Golub et al. (1999)
##D   # contained in multtest.
##D   library(multtest)
##D   data(golub)
##D   
##D   # golub.cl contains the class labels.
##D   golub.cl
##D 
##D   # Perform a SAM analysis for the two class unpaired case assuming
##D   # unequal variances.
##D   sam.out<-sam(golub,golub.cl,B=100,rand=123)
##D   sam.out
##D   
##D   # Obtain the Delta plots for the default set of Deltas
##D   plot(sam.out)
##D   
##D   # Generate the Delta plots for Delta = 0.2, 0.4, 0.6, ..., 2
##D   plot(sam.out,seq(0.2,0.4,2))
##D   
##D   # Obtain the SAM plot for Delta = 2
##D   plot(sam.out,2)
##D   
##D   # Get information about the genes called significant using 
##D   # Delta = 3 (since neither the gene names nor the chip type
##D   # has been specified ll is set to FALSE to avoid a warning)
##D   sam.sum3<-summary(sam.out,3,ll=FALSE)
##D   
##D   # Obtain the rows of golub containing the genes called
##D   # differentially expressed
##D   sam.sum3@row.sig.genes
##D   
##D   # and their names
##D   golub.gnames[sam.sum3@row.sig.genes,3] 
##D 
##D   # The matrix containing the d-values, q-values etc. of the
##D   # differentially expressed genes can be obtained by
##D   sam.sum3@mat.sig
##D   
##D   # Perform a SAM analysis using Wilcoxon rank sums
##D   sam(golub,golub.cl,method="wilc.stat",rand=123)
##D     
##D 
##D   # Now consider only the first ten columns of the Golub et al. (1999)
##D   # data set. For now, let's assume the first five columns were
##D   # before treatment measurements and the next five columns were
##D   # after treatment measurements, where column 1 and 6, column 2
##D   # and 7, ..., build a pair. In this case, the class labels
##D   # would be
##D   new.cl<-c(-(1:5),1:5)
##D   new.cl
##D   
##D   # and the corresponding SAM analysis for the two-class paired
##D   # case would be
##D   sam(golub[,1:10],new.cl,B=100,rand=123)
##D   
##D   # Another way of specifying the class labels for the above paired
##D   # analysis is
##D   mat.cl<-matrix(c(rep(c(-1,1),e=5),rep(1:5,2)),10)
##D   mat.cl
##D   
##D   # and the above SAM analysis can also be done by
##D   sam(golub[,1:10],mat.cl,B=100,rand=123)
## End(Not run)


