### Name: clusterVisualNone-class
### Title: Class "clusterVisualNone", a placeholder for the goCluster
###   visualization methods
### Aliases: clusterVisualNone-class config,clusterVisualNone-method
###   execute,clusterVisualNone-method reset,clusterVisualNone-method
###   setup,clusterVisualNone-method setup<-,clusterVisualNone-method
###   display,clusterVisualNone-method print,clusterVisualNone-method
### Keywords: classes

### ** Examples


set.seed(1000)

data(benomylsetupsmall)

a <- new("goCluster")

## This will result in an object without visualization
execute(a) <- benomylsetupsmall

## We can choose and add the visualization method afterwards

## Create the visualization method
b <- new("clusterVisualHeatmap")

## Assign the new method to the old goCluster object
a@visu <- b

## Prepare the visualization
a@visu <- execute(a@visu, a)

if(interactive()){
## This example can only be run in an interactive mode

## This plot shows only four genes since the loaded dataset
## has been reduced to only 100 genes. Try the same with
## the full dataset
display(a, selection = "GO:0003735")
}



