### Name: mlm2lm
### Title: Linear Model converting function
### Aliases: mlm2lm
### Keywords: models

### ** Examples

#library
library(Biobase)
library(LMGene)

#data
data(Smpd0)

# model information 
for(i in 1:length(Smpd0@phenoData@varLabels)){
  assign(paste('x', i, sep=''),as.factor(Smpd0@phenoData@pData[,i]))
}
  
fchar=''
for(i in 1:length(Smpd0@phenoData@varLabels)){
  fchar=paste(fchar, paste('x', i, sep=''), ifelse(i<length(Smpd0@phenoData@varLabels), '+', ''), sep='')
}
fchar2 <- paste("y ~",fchar)
#
# run regression and anovas
y <- t(as.matrix(Smpd0@exprs))
formobj <- as.formula(fchar2)
tmp <- lm(formobj)
class(tmp)

tmp2 <- mlm2lm(tmp,i)
class(tmp2)




