### Name: confint.segmentation
### Title: Compute Bai's confidence intervals for specified segmentations
### Aliases: confint.segmentation
### Keywords: manip

### ** Examples

   # generate random data with 5 segments:
   x <- c(rnorm(10,0,1),rnorm(10,3,1),rnorm(10,0.5,0.5),
          rnorm(10,1.5,1),rnorm(10,5,1))

   segres <-  findSegments(x, maxcp=10, maxk=15)
   segres <- confint.segmentation(segres,nSegments=c(3,4,5,6))

   # see that the step between segments 3 and 4 is less certain than
   #  the other ones:
   segres$confInt
   plot(segres,5, pch=20)



